/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.remote.FeatureMaker;
import ucar.nc2.stream.NcStream;

public class RemotePointFeatureIterator
extends PointIteratorAbstract {
    private HttpMethod method;
    private InputStream in;
    private FeatureMaker featureMaker;
    private PointFeature pf;
    private boolean finished = false;

    RemotePointFeatureIterator(HttpMethod method, InputStream in, FeatureMaker featureMaker) throws IOException {
        this.method = method;
        this.in = in;
        this.featureMaker = featureMaker;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        if (this.method != null) {
            this.method.releaseConnection();
        }
        this.method = null;
        this.finishCalcBounds();
        this.finished = true;
    }

    public boolean hasNext() throws IOException {
        if (this.finished) {
            return false;
        }
        int len = NcStream.readVInt(this.in);
        if (len <= 0) {
            this.pf = null;
            this.finish();
            return false;
        }
        byte[] b = new byte[len];
        NcStream.readFully(this.in, b);
        this.pf = this.featureMaker.make(b);
        return true;
    }

    public PointFeature next() throws IOException {
        if (null == this.pf) {
            return null;
        }
        this.calcBounds(this.pf);
        return this.pf;
    }

    public void setBufferSize(int bytes) {
    }
}

