/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinParentIndex
implements Join {
    private Structure parentStructure;
    private ArrayStructure parentData;
    private String parentIndex;

    public JoinParentIndex(Structure parentStructure, String parentIndex) {
        this.parentStructure = parentStructure;
        this.parentIndex = parentIndex;
        try {
            this.parentData = (ArrayStructure)parentStructure.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StructureData getJoinData(Cursor cursor) {
        StructureData sdata = cursor.tableData[0];
        int index = sdata.getScalarInt(this.parentIndex);
        return this.parentData.getStructureData(index);
    }

    public Variable findVariable(String axisName) {
        return this.parentStructure.findVariable(axisName);
    }

    public String toString() {
        return "JoinParentIndex{parentStructure=" + this.parentStructure + ", parentIndex='" + this.parentIndex + '}';
    }
}

