/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationProfileCollectionImpl;
import ucar.nc2.ft.point.StationProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardStationProfileCollectionImpl
extends StationProfileCollectionImpl {
    private DateUnit timeUnit;
    private NestedTable ft;
    private DateFormatter dateFormatter = new DateFormatter();

    StandardStationProfileCollectionImpl(NestedTable ft, DateUnit timeUnit) throws IOException {
        super(ft.getName());
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    protected void initStations() {
        if (this.stationHelper != null) {
            return;
        }
        this.stationHelper = new StationHelper();
        try {
            int count = 0;
            List<Station> stnList = this.ft.makeStations(-1);
            for (Station s : stnList) {
                this.stationHelper.addStation(new StandardStationProfileFeature(s, null, count++));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to init stations", ioe);
        }
    }

    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new NestedPointFeatureCollectionIterator(){
            private Iterator iter;
            {
                this.iter = StandardStationProfileCollectionImpl.this.getStations().iterator();
            }

            public boolean hasNext() throws IOException {
                return this.iter.hasNext();
            }

            public NestedPointFeatureCollection next() throws IOException {
                return (StandardStationProfileFeature)this.iter.next();
            }

            public void setBufferSize(int bytes) {
            }
        };
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        private Cursor cursor;
        private String desc;

        StandardProfileFeature(Station s, Date time, Cursor cursor) throws IOException {
            super(StandardStationProfileCollectionImpl.this.dateFormatter.toDateTimeStringISO(time), s.getLatitude(), s.getLongitude(), -1);
            this.cursor = cursor;
            this.desc = "time=" + time + "stn=" + s.getDescription();
        }

        public String getDescription() {
            return this.desc;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            StructureDataIterator structIter = StandardStationProfileCollectionImpl.this.ft.getStationProfileObsDataIterator(this.cursor, bufferSize);
            StandardPointFeatureIterator iter = new StandardPointFeatureIterator(StandardStationProfileCollectionImpl.this.ft, StandardStationProfileCollectionImpl.this.timeUnit, structIter, this.cursor.copy());
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }
    }

    private class StandardStationProfileFeature
    extends StationProfileFeatureImpl {
        Station s;
        StructureData stationData;
        int recnum;

        StandardStationProfileFeature(Station s, StructureData stationData, int recnum) {
            super(s, StandardStationProfileCollectionImpl.this.timeUnit, -1);
            this.s = s;
            this.stationData = stationData;
            this.recnum = recnum;
        }

        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardStationProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.what = this.s;
            cursor.recnum[2] = this.recnum;
            cursor.tableData[2] = this.stationData;
            cursor.parentIndex = 2;
            return new StandardStationProfileFeatureIterator(cursor);
        }

        private class StandardStationProfileFeatureIterator
        implements PointFeatureCollectionIterator {
            Cursor cursor;
            private StructureDataIterator iter;
            private int count = 0;

            StandardStationProfileFeatureIterator(Cursor cursor) throws IOException {
                this.cursor = cursor;
                this.iter = StandardStationProfileCollectionImpl.this.ft.getStationProfileDataIterator(cursor, -1);
            }

            public boolean hasNext() throws IOException {
                boolean r = this.iter.hasNext();
                if (!r) {
                    StandardStationProfileFeature.this.timeSeriesNpts = this.count;
                }
                return r;
            }

            public PointFeatureCollection next() throws IOException {
                Cursor cursorIter = this.cursor.copy();
                ++this.count;
                cursorIter.tableData[1] = this.iter.next();
                cursorIter.parentIndex = 1;
                double time = StandardStationProfileCollectionImpl.this.ft.getObsTime(cursorIter);
                return new StandardProfileFeature(StandardStationProfileFeature.this.s, StandardStationProfileFeature.this.timeUnit.makeDate(time), cursorIter);
            }

            public void setBufferSize(int bytes) {
                this.iter.setBufferSize(bytes);
            }

            public void finish() {
            }
        }
    }
}

