/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class FslWindProfiler
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String title = ds.findAttValueIgnoreCase(null, "title", null);
        return title != null && (title.startsWith("WPDN data") || title.startsWith("RASS data"));
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        TableConfig profile = new TableConfig(Table.Type.Structure, "record");
        profile.structName = "record";
        profile.dim = Evaluator.getDimension(ds, "recNum", errlog);
        profile.time = Evaluator.getVariableName(ds, "timeObs", errlog);
        profile.stnId = Evaluator.getVariableName(ds, "staName", errlog);
        profile.stnWmoId = Evaluator.getVariableName(ds, "wmoStaNum", errlog);
        profile.lat = Evaluator.getVariableName(ds, "staLat", errlog);
        profile.lon = Evaluator.getVariableName(ds, "staLon", errlog);
        profile.featureType = FeatureType.PROFILE;
        TableConfig levels = new TableConfig(Table.Type.MultiDimInner, "levels");
        levels.outer = Evaluator.getDimension(ds, "recNum", errlog);
        levels.dim = Evaluator.getDimension(ds, "level", errlog);
        levels.elev = Evaluator.getVariableName(ds, "levels", errlog);
        profile.addChild(levels);
        return profile;
    }
}

