/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.HashMap;
import java.util.Map;
import ucar.nc2.iosp.bufr.DataDescriptor;

public class BitCounterUncompressed {
    private final DataDescriptor dkey;
    private final int nrows;
    private final int replicationCountSize;
    private Map<DataDescriptor, BitCounterUncompressed[]> subCounters;
    private int[] startBit;
    private int countBits;
    private static boolean debug = false;

    public BitCounterUncompressed(DataDescriptor dkey, int nrows, int replicationCountSize) {
        this.dkey = dkey;
        this.nrows = nrows;
        this.replicationCountSize = replicationCountSize;
    }

    public BitCounterUncompressed makeNested(DataDescriptor subKey, int n, int index, int replicationCountSize) {
        BitCounterUncompressed rc;
        BitCounterUncompressed[] subCounter;
        if (this.subCounters == null) {
            this.subCounters = new HashMap<DataDescriptor, BitCounterUncompressed[]>(5);
        }
        if ((subCounter = this.subCounters.get(subKey)) == null) {
            subCounter = new BitCounterUncompressed[this.nrows];
            this.subCounters.put(subKey, subCounter);
        }
        subCounter[index] = rc = new BitCounterUncompressed(subKey, n, replicationCountSize);
        return rc;
    }

    public BitCounterUncompressed[] getNested(DataDescriptor subKey) {
        return this.subCounters == null ? null : this.subCounters.get(subKey);
    }

    int countBits(int startBit) {
        this.countBits = this.replicationCountSize;
        this.startBit = new int[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            this.startBit[i] = startBit + this.countBits;
            if (debug) {
                System.out.println(" BitCounterUncompressed row " + i + " startBit=" + this.startBit[i]);
            }
            for (DataDescriptor nd : this.dkey.subKeys) {
                BitCounterUncompressed[] bitCounter;
                BitCounterUncompressed[] bitCounterUncompressedArray = bitCounter = this.subCounters == null ? null : this.subCounters.get(nd);
                if (bitCounter == null) {
                    this.countBits += nd.getBitWidth();
                    continue;
                }
                if (debug) {
                    System.out.println(" ---------> nested " + nd.getFxyName() + " starts at =" + (startBit + this.countBits));
                }
                this.countBits += bitCounter[i].countBits(startBit + this.countBits);
                if (!debug) continue;
                System.out.println(" <--------- nested " + nd.getFxyName() + " ends at =" + (startBit + this.countBits));
            }
        }
        return this.countBits;
    }

    public int getCountBits() {
        return this.countBits;
    }

    public int getNumberRows() {
        return this.nrows;
    }

    public int getStartBit(int row) {
        if (row >= this.startBit.length) {
            throw new IllegalStateException();
        }
        return this.startBit[row];
    }
}

