/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTableB {
    String bmt = "file:C:/dev/tds/bufr/resources/source/britMet/BUFR_B_080731.xml";
    String robbt = "C:/dev/tds/bufr/resources/resources/bufr/tables/B4M-000-013-B";
    String diffTableDir = "C:/dev/tds/bufr/resources/resources/bufr/tables/";
    String[] diffTable = new String[]{"B2M-000-002-B.diff", "B3M-000-003-B.diff", "B3M-000-004-B.diff", "B3M-000-005-B.diff", "B3M-000-006-B.diff", "B3M-000-007-B.diff", "B3M-000-008-B.diff", "B3M-000-009-B.diff", "B3M-000-010-B.diff", "B3M-000-011-B.diff", "B3M-000-012-B.diff"};
    Pattern pattern = Pattern.compile("(.*)\\([sS]ee [nN]ote.*");
    static Map<Integer, Feature> bmTable = new TreeMap<Integer, Feature>();
    Map<Integer, List<String>> problems = new TreeMap<Integer, List<String>>();
    String tableDirName = "C:\\dev\\tds\\bufr\\resources\\resources\\bufr\\tables\\";

    public void readBmt() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.bmt);
            Element root = doc.getRootElement();
            int count = this.makeBmtTable(root.getChildren("featureCatalogue"));
            System.out.println(" bmt count= " + count);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int makeBmtTable(List<Element> featureCatList) {
        int count = 0;
        System.out.printf("Parsing BritMet file %s%n", this.bmt);
        for (Element featureCat : featureCatList) {
            List features = featureCat.getChildren("feature");
            count += features.size();
            for (Element feature : features) {
                String name = feature.getChild("annotation").getChildTextNormalize("documentation");
                int f = Integer.parseInt(feature.getChildText("F"));
                int x = Integer.parseInt(feature.getChildText("X"));
                int y = Integer.parseInt(feature.getChildText("Y"));
                int fxy = (f << 16) + (x << 8) + y;
                Element bufrElem = feature.getChild("BUFR");
                String units = bufrElem.getChildTextNormalize("BUFR_units");
                int scale = 0;
                int reference = 0;
                int width = 0;
                String s = null;
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_scale");
                    scale = Integer.parseInt(this.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad scale='%s'%n", this.fxy(fxy), name, s);
                }
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_reference");
                    reference = Integer.parseInt(this.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad reference='%s' %n", this.fxy(fxy), name, s);
                }
                try {
                    s = bufrElem.getChildTextNormalize("BUFR_width");
                    width = Integer.parseInt(this.clean(s));
                }
                catch (NumberFormatException e) {
                    System.out.printf(" key %s name '%s' has bad width='%s' %n", this.fxy(fxy), name, s);
                }
                Feature feat = new Feature(fxy, name, units, scale, reference, width);
                bmTable.put(fxy, feat);
            }
        }
        return count;
    }

    String clean(String s) {
        return StringUtil.remove(s, 32);
    }

    public void readTable(String filename, Map<Integer, Feature> map) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charset.forName("UTF8")));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] flds = line.split("; ");
            if (flds.length < 8) {
                System.out.println("BAD line == " + line);
                continue;
            }
            int i = 0;
            int f = Integer.parseInt(flds[i++]);
            int x = Integer.parseInt(flds[i++]);
            int y = Integer.parseInt(flds[i++]);
            int scale = Integer.parseInt(flds[i++]);
            int reference = Integer.parseInt(flds[i++]);
            int width = Integer.parseInt(flds[i++]);
            String units = flds[i++];
            String name = flds[i++];
            int fxy = (f << 16) + (x << 8) + y;
            Feature feat = new Feature(fxy, this.norm(name), units, scale, reference, width);
            map.put(fxy, feat);
            ++count;
        }
        System.out.println(filename + " count= " + count);
    }

    String norm(String s) {
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            return s;
        }
        return matcher.group(1);
    }

    void addProblem(String fname, Integer key, String p) {
        List<String> list = this.problems.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.problems.put(key, list);
        }
        list.add(p + " (" + fname + ")");
    }

    public void compare(String fname, Map<Integer, Feature> thisMap, Map<Integer, Feature> thatMap) {
        for (Integer key : thisMap.keySet()) {
            Feature f1 = thisMap.get(key);
            Feature f2 = thatMap.get(key);
            if (f2 == null) {
                System.out.printf(" No key %s %n", this.fxy(key));
                continue;
            }
            if (f1.scale != f2.scale) {
                System.out.printf(" key %s scale %d != %d %n", this.fxy(key), f1.scale, f2.scale);
                this.addProblem(fname, key, "scale " + f1.scale + " != " + f2.scale);
            }
            if (f1.reference != f2.reference) {
                System.out.printf(" key %s reference %d != %d %n", this.fxy(key), f1.reference, f2.reference);
                this.addProblem(fname, key, "refer " + f1.reference + " != " + f2.reference);
            }
            if (f1.width == f2.width) continue;
            System.out.printf(" key %s width %d != %d %n", this.fxy(key), f1.width, f2.width);
            this.addProblem(fname, key, "width " + f1.width + " != " + f2.width);
        }
    }

    public void compare2(Map<Integer, Feature> thisMap, Map<Integer, Feature> thatMap) {
        for (Integer key : thisMap.keySet()) {
            Feature f1 = thisMap.get(key);
            Feature f2 = thatMap.get(key);
            if (f2 != null) continue;
            System.out.printf(" No key %s %n", this.fxy(key));
        }
    }

    String fxy(int fxy) {
        int f = fxy >> 16;
        int x = (fxy & 0xFF00) >> 8;
        int y = fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    public void compareDiff() throws IOException {
        TreeMap<Integer, Feature> wmoMap = new TreeMap<Integer, Feature>();
        this.readTable(this.robbt, wmoMap);
        for (String fname : this.diffTable) {
            System.out.printf("=============================================================%n", new Object[0]);
            TreeMap<Integer, Feature> diffMap = new TreeMap<Integer, Feature>();
            this.readTable(this.diffTableDir + fname, diffMap);
            System.out.printf("Compare diff (" + fname + ") to standard %n", new Object[0]);
            this.compare(fname, diffMap, wmoMap);
        }
        Set<Integer> keys = this.problems.keySet();
        for (Integer key : keys) {
            System.out.printf("%n%s%n", this.fxy(key));
            List<String> list = this.problems.get(key);
            for (String p : list) {
                System.out.printf(" %s%n", p);
            }
        }
    }

    public void compareBrit() throws IOException {
        this.readBmt();
        TreeMap<Integer, Feature> robbMap = new TreeMap<Integer, Feature>();
        this.readTable(this.robbt, robbMap);
        System.out.printf("Compare britMet to ours %n", new Object[0]);
        this.compare(this.bmt, bmTable, robbMap);
        System.out.printf("%n Compare britMet to ours %n", new Object[0]);
        this.compare2(robbMap, bmTable);
    }

    public static void main2(String[] args) throws IOException {
        CompareTableB ct = new CompareTableB();
        ct.compareBrit();
    }

    void addToMap(TableName t, Map<Short, DescTrack> mapAll) throws IOException {
        System.out.printf("Read (" + t.filename + ")%n", new Object[0]);
        TableB tableB = BufrTables.readTableB(this.tableDirName + t.filename);
        Collection<TableB.Descriptor> desc = tableB.getDescriptors();
        for (TableB.Descriptor d : desc) {
            short fxy = d.getId();
            if (!Descriptor.isWmoRange(fxy)) continue;
            DescTrack f = mapAll.get(fxy);
            if (f == null) {
                f = new DescTrack(fxy);
                mapAll.put(fxy, f);
            }
            f.add(d, t.name);
        }
    }

    public void compareAll() throws IOException {
        String where0;
        DescTrack dtrack;
        TableName[] tables = new TableName[]{new TableName("WMO", "B4M-000-014-B"), new TableName("NCEP", "NCEPtable-B.diff"), new TableName("Brazil", "B4L-046-013-B.diff"), new TableName("ECMWF", "B4L-098-013-B.diff"), new TableName("FNMOC", "B4L-058-013-B.diff"), new TableName("Eumetsat", "B3L-254-011-B.diff")};
        int[] want = new int[]{0, 1};
        TreeMap<Short, DescTrack> mapAll = new TreeMap<Short, DescTrack>();
        for (int i = 0; i < tables.length; ++i) {
            this.addToMap(tables[i], mapAll);
        }
        Set keys = mapAll.keySet();
        ArrayList sortKeys = new ArrayList(keys);
        Collections.sort(sortKeys);
        System.out.printf("pass one for differences with WMO%n", new Object[0]);
        for (Short key : sortKeys) {
            dtrack = (DescTrack)mapAll.get(key);
            if (dtrack.descList.size() < 2 || !(where0 = dtrack.whereList.get(0)).equals("WMO")) continue;
            TableB.Descriptor wmo = null;
            System.out.printf("%nFxy=%s%n", Descriptor.makeString(key));
            for (int i = 0; i < dtrack.descList.size(); ++i) {
                TableB.Descriptor bdesc = dtrack.descList.get(i);
                String where = dtrack.whereList.get(i);
                System.out.printf(" %s == %s%n", bdesc, where);
                if (i == 0) {
                    wmo = bdesc;
                    continue;
                }
                System.out.printf("**%s%n", this.compare(wmo, bdesc));
            }
        }
        System.out.printf("%n===========================%n", new Object[0]);
        System.out.printf("%npass two for addition to WMO%n", new Object[0]);
        for (Short key : sortKeys) {
            dtrack = (DescTrack)mapAll.get(key);
            where0 = dtrack.whereList.get(0);
            if (where0.equals("WMO")) continue;
            System.out.printf("%nFxy=%s%n", Descriptor.makeString(key));
            for (int i = 0; i < dtrack.descList.size(); ++i) {
                TableB.Descriptor bdesc = dtrack.descList.get(i);
                String where = dtrack.whereList.get(i);
                System.out.printf(" %s == %s%n", bdesc, where);
            }
        }
    }

    String compare(TableB.Descriptor f1, TableB.Descriptor f2) {
        StringBuilder sb = new StringBuilder();
        if (!f1.getUnits().equalsIgnoreCase(f2.getUnits())) {
            sb.append(" units");
        }
        if (f1.getScale() != f2.getScale()) {
            sb.append(" scale");
        }
        if (f1.getRefVal() != f2.getRefVal()) {
            sb.append(" refVal");
        }
        if (f1.getWidth() != f2.getWidth()) {
            sb.append(" width");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        CompareTableB ct = new CompareTableB();
        ct.compareAll();
    }

    class TableName {
        String filename;
        String name;

        TableName(String name, String filename) {
            this.name = name;
            this.filename = filename;
        }
    }

    class DescTrack {
        short id;
        List<TableB.Descriptor> descList = new ArrayList<TableB.Descriptor>(10);
        List<String> whereList = new ArrayList<String>(10);

        DescTrack(short id) {
            this.id = id;
        }

        void add(TableB.Descriptor d, String where) {
            this.descList.add(d);
            this.whereList.add(where);
        }

        void showSingles() {
            String where0;
            if (this.descList.size() < 2 && (where0 = this.whereList.get(0)).equals("WHO")) {
                return;
            }
            for (int i = 0; i < this.descList.size(); ++i) {
                TableB.Descriptor bdesc = this.descList.get(i);
                String where = this.whereList.get(i);
                System.out.printf(" %s == %s%n", bdesc, where);
            }
        }
    }

    class Feature {
        int fxy;
        int scale;
        int reference;
        int width;
        String name;
        String units;

        Feature(int fxy, String name, String units, int scale, int reference, int width) {
            this.fxy = fxy;
            this.name = name.trim();
            this.units = units.trim();
            this.scale = scale;
            this.reference = reference;
            this.width = width;
        }
    }
}

