/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import ucar.unidata.util.StringUtil;

public final class GempakUtil {
    private static int[] month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static String[] vertCoords = new String[]{"NONE", "PRES", "THTA", "HGHT", "SGMA", "DPTH", "HYBL"};

    public static int[] TG_FTOI(int[] iftime, int start) {
        int[] intdtf = new int[3];
        if (iftime[start] < 100000000) {
            intdtf[0] = iftime[start];
            intdtf[1] = iftime[start + 1];
            intdtf[2] = 0;
        } else {
            intdtf[0] = iftime[start] / 10000;
            intdtf[1] = iftime[start] - intdtf[0] * 10000;
            int mmdd = intdtf[0] / 100;
            int iyyy = intdtf[0] - mmdd * 100;
            intdtf[0] = iyyy * 10000 + mmdd;
            intdtf[2] = iftime[start + 1];
        }
        return intdtf;
    }

    public static String TG_ITOC(int[] intdtf) {
        String gdattim = "";
        if (intdtf[0] == 0 && intdtf[2] == 0 && intdtf[2] == 0) {
            return gdattim;
        }
        gdattim = GempakUtil.TI_CDTM(intdtf[0], intdtf[1]);
        if (intdtf[2] != 0) {
            String[] timeType = GempakUtil.TG_CFTM(intdtf[2]);
            String ftype = timeType[0];
            String ftime = timeType[1];
            gdattim = gdattim.substring(0, 11) + ftype + ftime;
        }
        return gdattim;
    }

    public static String[] TG_CFTM(int ifcast) {
        String ftype = "";
        String ftime = "";
        if (ifcast < 0) {
            return new String[]{ftype, ftime};
        }
        int iftype = ifcast / 100000;
        if (iftype == 0) {
            ftype = "A";
        } else if (iftype == 1) {
            ftype = "F";
        } else if (iftype == 2) {
            ftype = "G";
        } else if (iftype == 3) {
            ftype = "I";
        }
        int iftime = ifcast - iftype * 100000;
        int ietime = iftime + 100000;
        String fff = GempakUtil.ST_INCH(ietime);
        ftime = ietime % 100 == 0 ? fff.substring(1, 4) : fff.substring(1);
        return new String[]{ftype, ftime};
    }

    public static String TI_CDTM(int idate, int itime) {
        int[] idtarr;
        idtarr = new int[]{idate / 10000, (idate - idtarr[0] * 10000) / 100, idate % 100, itime / 100, itime % 100};
        String dattim = GempakUtil.TI_ITOC(idtarr);
        return dattim;
    }

    public static String TI_ITOC(int[] idtarr) {
        String dattim = "";
        int iyear = idtarr[0];
        int imonth = idtarr[1];
        int iday = idtarr[2];
        int ihour = idtarr[3];
        int iminut = idtarr[4];
        int ndays = GempakUtil.TI_DAYM(iyear, imonth);
        int idate = (iyear %= 100) * 10000 + imonth * 100 + iday;
        int itime = ihour * 100 + iminut;
        String date = StringUtil.padZero(idate, 6);
        String time = StringUtil.padZero(itime, 4);
        dattim = date + "/" + time;
        return dattim;
    }

    public static int TI_DAYM(int iyear, int imon) {
        int iday = 0;
        if (imon > 0 && imon < 13) {
            iday = month[imon - 1];
            if (imon == 2 && GempakUtil.LEAP(iyear)) {
                ++iday;
            }
        }
        return iday;
    }

    public static boolean LEAP(int iyr) {
        return iyr % 4 == 0 && (iyr % 100 != 0 || iyr % 400 == 0);
    }

    public static String ST_INCH(int value) {
        return String.valueOf(value);
    }

    public static String ST_ITOC(int value) {
        byte[] bval = new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
        return new String(bval);
    }

    public static String ST_ITOC(int[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(GempakUtil.ST_ITOC(values[i]));
        }
        return sb.toString();
    }

    public static boolean ERMISS(float value) {
        return Math.abs(value - -9999.0f) < 0.1f;
    }

    public static String LV_CCRD(int ivcord) {
        String vcoord = "";
        if (ivcord >= 0 && ivcord < vertCoords.length) {
            vcoord = vertCoords[ivcord];
        } else if (ivcord > 100) {
            vcoord = GempakUtil.ST_ITOC(ivcord);
        }
        return vcoord;
    }

    public static int swp4(int value) {
        return Integer.reverseBytes(value);
    }

    public static int[] swp4(int[] values, int startIndex, int number) {
        for (int i = startIndex; i < startIndex + number; ++i) {
            values[i] = Integer.reverseBytes(values[i]);
        }
        return values;
    }

    public static String getGridPackingName(int pktyp) {
        String packingType = "UNKNOWN";
        switch (pktyp) {
            case 0: {
                packingType = "MDGNON";
                break;
            }
            case 1: {
                packingType = "MDGGRB";
                break;
            }
            case 2: {
                packingType = "MDGNMC";
                break;
            }
            case 3: {
                packingType = "MDGDIF";
                break;
            }
            case 4: {
                packingType = "MDGDEC";
                break;
            }
            case 5: {
                packingType = "MDGRB2";
                break;
            }
        }
        return packingType;
    }
}

