/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFile;
import ucar.nc2.ncml.DatasetScanner2;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCollectionManager2 {
    private static Logger logger = LoggerFactory.getLogger(DatasetCollectionManager2.class);
    private static boolean debugSyncDetail = false;
    private List<DatasetScanner2> scanList = new ArrayList<DatasetScanner2>();
    private Map<String, MFile> map;
    private TimeUnit recheck;
    private long lastScanned;

    public DatasetCollectionManager2(String recheckS) {
        if (recheckS != null) {
            try {
                this.recheck = new TimeUnit(recheckS);
            }
            catch (Exception e) {
                logger.error("Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, String dateFormatString) {
        this.scanList.add(new DatasetScanner2(dirName, suffix, regexpPatternString, subdirsS, olderS, dateFormatString));
    }

    public void scan(CancelTask cancelTask) throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap, cancelTask);
        this.map = newMap;
        this.lastScanned = System.currentTimeMillis();
    }

    public boolean timeToRescan() {
        if (this.scanList.isEmpty()) {
            if (debugSyncDetail) {
                System.out.println(" *Sync not needed, no scanners");
            }
            return false;
        }
        if (this.recheck == null) {
            if (debugSyncDetail) {
                System.out.println(" *Sync not needed, recheck is null");
            }
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            if (logger.isDebugEnabled()) {
                logger.debug(" *Sync not needed, last= " + lastCheckedDate + " now = " + now);
            }
            return false;
        }
        return true;
    }

    public boolean rescan() throws IOException {
        String path;
        if (logger.isDebugEnabled()) {
            logger.debug(" *Sync at " + new Date());
        }
        this.lastScanned = System.currentTimeMillis();
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap, null);
        boolean changed = false;
        for (MFile newDataset : newMap.values()) {
            path = newDataset.getPath();
            MFile oldDataset = this.map.get(path);
            if (oldDataset != null) {
                newMap.put(path, oldDataset);
                if (!debugSyncDetail) continue;
                System.out.println("  sync using old Dataset= " + path);
                continue;
            }
            changed = true;
            if (!debugSyncDetail) continue;
            System.out.println("  sync found new Dataset= " + path);
        }
        if (!changed) {
            for (MFile oldDataset : this.map.values()) {
                path = oldDataset.getPath();
                MFile newDataset = (MFile)newMap.get(path);
                if (newDataset != null) continue;
                changed = true;
                if (!debugSyncDetail) break;
                System.out.println("  sync found deleted Dataset= " + path);
                break;
            }
        }
        if (changed) {
            this.map = newMap;
        }
        return changed;
    }

    public TimeUnit getRecheck() {
        return this.recheck;
    }

    public long getLastScanned() {
        return this.lastScanned;
    }

    public Collection<MFile> getFiles() {
        return this.map.values();
    }

    private void scan(Map<String, MFile> map, CancelTask cancelTask) throws IOException {
        for (DatasetScanner2 scanner : this.scanList) {
            List<MFile> result = scanner.scanDirectory(cancelTask);
            for (MFile mfile : result) {
                map.put(mfile.getPath(), mfile);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }
}

