/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.io.PrintStream;
import java.util.Arrays;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class RotatedLatLon
extends ProjectionImpl {
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private static boolean show = false;
    private double lonpole;
    private double latpole;
    private double polerotate;
    private double cosDlat;
    private double sinDlat;

    public RotatedLatLon() {
        this(0.0, 0.0, 0.0);
    }

    public RotatedLatLon(double southPoleLat, double southPoleLon, double southPoleAngle) {
        this.latpole = southPoleLat;
        this.lonpole = southPoleLon;
        this.polerotate = southPoleAngle;
        double dlat_rad = (this.latpole - -90.0) * (Math.PI / 180);
        this.sinDlat = Math.sin(dlat_rad);
        this.cosDlat = Math.cos(dlat_rad);
        this.addParameter("grid_mapping_name", "rotated_lat_lon");
        this.addParameter("grid_south_pole_latitude", southPoleLat);
        this.addParameter("grid_south_pole_longitude", southPoleLon);
        this.addParameter("grid_south_pole_angle", southPoleAngle);
    }

    public ProjectionImpl constructCopy() {
        return new RotatedLatLon(this.latpole, this.lonpole, this.polerotate);
    }

    public String paramsToString() {
        return " southPoleLat =" + this.latpole + " southPoleLon =" + this.lonpole + " southPoleAngle =" + this.polerotate;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double[] lonlat = new double[]{latlon.getLongitude(), latlon.getLatitude()};
        double[] rlonlat = this.rotate(lonlat, this.lonpole, this.polerotate, this.sinDlat);
        if (destPoint == null) {
            destPoint = new ProjectionPointImpl(rlonlat[0], rlonlat[1]);
        } else {
            destPoint.setLocation(rlonlat[0], rlonlat[1]);
        }
        if (show) {
            System.out.println("LatLon= " + latlon + " proj= " + destPoint);
        }
        return destPoint;
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double[] lonlat = new double[]{ppt.getX(), ppt.getY()};
        double[] rlonlat = this.rotate(lonlat, -this.polerotate, -this.lonpole, -this.sinDlat);
        if (destPoint == null) {
            destPoint = new LatLonPointImpl(rlonlat[1], rlonlat[0]);
        } else {
            destPoint.set(rlonlat[1], rlonlat[0]);
        }
        if (show) {
            System.out.println("Proj= " + ppt + " latlon= " + destPoint);
        }
        return destPoint;
    }

    private double[] rotate(double[] lonlat, double rot1, double rot2, double s) {
        double e = Math.PI / 180 * (lonlat[0] - rot1);
        double n = Math.PI / 180 * lonlat[1];
        double cn = Math.cos(n);
        double x = cn * Math.cos(e);
        double y = cn * Math.sin(e);
        double z = Math.sin(n);
        double x2 = this.cosDlat * x + s * z;
        double z2 = -s * x + this.cosDlat * z;
        double R = Math.sqrt(x2 * x2 + y * y);
        double e2 = Math.atan2(y, x2);
        double n2 = Math.atan2(z2, R);
        double rlon = 57.29577951308232 * e2 - rot2;
        double rlat = 57.29577951308232 * n2;
        return new double[]{rlon, rlat};
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof RotatedLatLon)) {
            return false;
        }
        RotatedLatLon oo = (RotatedLatLon)proj;
        return this.lonpole == oo.lonpole && this.latpole == oo.latpole && this.polerotate == oo.polerotate;
    }

    private static void test() {
        Test tst0 = new Test(0.0, -25.0, 0.0);
        double[] pos = tst0.proj(0.0, -25.0, true);
        double[] pos2 = tst0.proj(pos[0], pos[1], false);
        double[] pos3 = tst0.proj(-46.5, -36.5, false);
        double[] pos4 = tst0.proj(46.9, 38.9, false);
        Test t = new Test(0.0, 90.0, 0.0);
        t.test(0.0f, 0.0f);
        t.test(90.0f, 0.0f);
        t.test(0.0f, 30.0f);
        t = new Test(0.0, 0.0, 0.0);
        t.test(0.0f, 0.0f);
        t.test(90.0f, 0.0f);
        t.test(0.0f, 30.0f);
        t = new Test(10.0, 50.0, 25.0);
        t.test(0.0f, 0.0f);
        t.test(90.0f, 0.0f);
        t.test(0.0f, 30.0f);
        t = null;
        RotatedLatLon rll = new RotatedLatLon(-50.0, 10.0, 20.0);
        long t0 = System.currentTimeMillis();
        long dt = 0L;
        double[] p = new double[]{12.0, 60.0};
        int i = 0;
        while (dt < 1000L) {
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            rll.rotate(p, rll.lonpole, rll.polerotate, rll.sinDlat);
            ++i;
            dt = System.currentTimeMillis() - t0;
        }
        System.out.println("fwd/sec: " + i * 10);
    }

    public static void main(String[] args) {
        RotatedLatLon.test();
    }

    private static class Test {
        RotatedLatLon rll;
        static PrintStream ps = System.out;
        static final double err = 1.0E-4;

        public Test(double lo, double la, double rot) {
            this.rll = new RotatedLatLon(la, lo, rot);
            ps.println("lonsp:" + this.rll.lonpole + ", latsp:" + this.rll.latpole + ", rotsp:" + this.rll.polerotate);
        }

        void pr(double[] pos, double[] pos2, double[] pos3) {
            ps.println(" " + pos[0] + "   " + pos[1]);
            ps.println("    fwd: " + pos2[0] + "   " + pos2[1]);
            ps.println("    inv: " + pos3[0] + "   " + pos3[1]);
        }

        private double[] test(float lon, float lat) {
            double[] p = new double[]{lon, lat};
            double[] p2 = this.rll.rotate(p, this.rll.lonpole, this.rll.polerotate, this.rll.sinDlat);
            double[] p3 = this.rll.rotate(p2, -this.rll.polerotate, -this.rll.lonpole, -this.rll.sinDlat);
            assert (Math.abs(p[0] - p3[0]) < 1.0E-4);
            assert (Math.abs(p[1] - p3[1]) < 1.0E-4);
            this.pr(p, p2, p3);
            return p2;
        }

        double[] proj(double lon, double lat, boolean fwd) {
            double[] pos = new double[]{lon, lat};
            double[] pos2 = fwd ? this.rll.rotate(pos, this.rll.lonpole, this.rll.polerotate, this.rll.sinDlat) : this.rll.rotate(pos, -this.rll.polerotate, -this.rll.lonpole, -this.rll.sinDlat);
            ps.println((fwd ? " fwd" : " inv") + " [" + lon + ", " + lat + "] -> " + Arrays.toString(pos2));
            return pos2;
        }
    }
}

