/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridSigmaPressure
extends VerticalTransformImpl {
    public static final String P0 = "P0_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String A = "A_variableName";
    public static final String AP = "AP_variableName";
    public static final String B = "B_variableName";
    private double p0;
    private Variable psVar;
    private Variable aVar;
    private Variable bVar;
    private Variable p0Var;
    private Array aArray = null;
    private Array bArray = null;

    public HybridSigmaPressure(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String psName = this.getParameterStringValue(params, PS);
        String aName = this.getParameterStringValue(params, A);
        String bName = this.getParameterStringValue(params, B);
        String p0Name = this.getParameterStringValue(params, P0);
        String apName = this.getParameterStringValue(params, AP);
        this.aVar = apName != null ? ds.findVariable(apName) : ds.findVariable(aName);
        this.psVar = ds.findVariable(psName);
        this.bVar = ds.findVariable(bName);
        if (p0Name != null) {
            this.p0Var = ds.findVariable(p0Name);
        }
        this.units = ds.findAttValueIgnoreCase(this.psVar, "units", "none");
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
            this.p0 = this.p0Var == null ? 1.0 : this.p0Var.readScalarDouble();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        int[] shape2D = psArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index psIndex = psArray.getIndex();
        ArrayDouble.D3 press = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double term1 = this.aArray.getDouble(aIndex.set(z)) * this.p0;
            double bz = this.bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double ps = psArray.getDouble(psIndex.set(y, x));
                    press.set(z, y, x, term1 + bz * ps);
                }
            }
        }
        return press;
    }
}

