<?
/**
 * Samurai
 * 
 * SamuraiFWのメインクラス。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool,Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
if(!defined('SAMURAI_DIR')) define('SAMURAI_DIR', dirname(__FILE__));
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
if(!defined('PS')) define('PS', PATH_SEPARATOR);
include_once('Samurai/component/samurai/I18n.class.php');
include_once('Samurai/component/samurai/Exception.class.php');
include_once('Samurai/component/samurai/Loader.class.php');
include_once('Samurai/component/samurai/Yaml.class.php');
include_once('Samurai/component/samurai/Config.class.php');
include_once('Samurai/component/samurai/container/Factory.class.php');
class Samurai
{
    const
        /** @var        string  バージョン */
        VERSION = '2.0.0';
    private static
        /** @var        array   SAMURAI_DIR候補 */
        $_samurai_dirs = array(SAMURAI_DIR);
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    /**
     * SamuraiFWの初期化を行う。
     * 一度だけ呼び出せばよい。
     * @access     public
     */
    public static function init()
    {
        //スタート
        define('SAMURAI_START', microtime(true));
        //設定情報の取得
        Samurai_Config::import('config/samurai/config.yml');
        //DIContainerの初期化
        $Container = self::getContainer();
        $Container->import(Samurai_Config::get('container.dicon'));
        //Loggerの初期化
        Samurai_Loader::load('component/samurai/Logger.class.php');
        $loggers = Samurai_Config::get('loggers');
        foreach((array)$loggers as $alias => $define){
            Samurai_Logger::addClient($alias, $define);
        }
    }
    
    
    /**
     * DIContainerの取得。
     * @access     public
     * @return     object  Samurai_Container
     */
    public static function getContainer($namespace=NULL)
    {
        if($namespace === NULL) $namespace = Samurai_Config::get('container.name');
        return Samurai_Container_Factory::create($namespace);
    }
    
    
    
    /**
     * samurai_dirを追加する。
     * @access     public
     * @return     array   samurai_dir
     */
    public static function getSamuraiDirs()
    {
        return self::$_samurai_dirs;
    }
    
    
    /**
     * samurai_dirを追加する。
     * @param      string  $dir   ディレクトリ
     */
    public static function unshiftSamuraiDir($dir)
    {
        array_unshift(self::$_samurai_dirs, $dir);
    }
}


/**
 * __autoloadの設定。
 * spl_autoload_registerを使用したかったのだが、>=5.1.2の環境を強要するために
 * __autoload関数で対処。
 * @access     public
 * @param      string  $class_name   クラス名
 */
function __autoload($class_name)
{
    Samurai_Loader::autoload($class_name);
}
