<?
/**
 * Etc_Helper_Pager_Unit
 * 
 * Pagerの基本ユニット。
 * Pagingに必要な基本的な能力を一通り備えている。
 * 
 * @package    Helper
 * @subpackage Pager
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Helper_Pager_Unit
{
    public
        /** @var        int     現在のオフセット */
        $offset = 0,
        /** @var        int     1ページの表示件数 */
        $per_page = 10,
        /** @var        string  pageを保持するリクエストキー */
        $url_var = 'page',
        /** @var        int     アイテムの総件数 */
        $total_items = 0,
        /** @var        object  Request */
        $Request;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * 次のページがあるかどうか。
     * @access     public
     * @return     mixed   次のページID
     */
    public function hasNext()
    {
        $page = $this->getNow();
        if($this->total_items - $page * $this->per_page > 0){
            return $page+1;
        } else {
            return false;
        }
    }
    
    
    /**
     * 前のページがあるかどうか。
     * @access     public
     * @return     mixed   前のページID
     */
    public function hasPrev()
    {
        $page = $this->getNow();
        if($page > 1){
            return $page - 1;
        } else {
            return false;
        }
    }
    
    
    /**
     * 現在のページを取得する。
     * @access     public
     * @return     int     現在のページID
     */
    public function getNow()
    {
        $page = $this->Request->getParameter($this->url_var);
        if(!$page || !is_numeric($page)){
            $page = ceil( ($this->offset + 1) / $this->per_page );
        }
        return (int)$page;
    }
    
    
    /**
     * 何件目から取得しているかを返却。
     * @access     public
     * @return     int     何件目から取得しているか
     */
    public function getStart()
    {
        return $this->offset + 1;
    }
    
    
    /**
     * 何件目まで取得しているかを返却。
     * @access     public
     * @return     int     何件目まで取得しているか
     */
    public function getEnd()
    {
        //次ページがある場合はそのページでのMaxまで
        if($this->hasNext()){
            return $this->getStart() + $this->perPage - 1;
        }
        //そうでない場合はMax値を
        else {
            return $this->total_items;
        }
    }
    
    
    
    
    
    /**
     * Pear::Pagerのslidingモードのようにページを取得できる。
     * Pear::Pagerはリンクを直接吐くが、これはページの配列を返す。
     * @access     public
     * @param      int     $delta   現在のページサイドに表示するリンク数
     * @return     array   sliding配列
     */
    public function sliding($delta=5)
    {
        $pages = array();
        $page_count = ceil($this->total_items / $this->per_page);
        $page_now = $this->getNow();
        $all_delta = $delta * 2 + 1;
        //基準点追加
        $pages[] = $page_now;
        for($i=1; count($pages) < $all_delta; $i++){
            //手前に余裕があれば入れる
            if($page_now - $i > 0) $pages[] = $page_now - $i;
            //後ろに余裕があれば入れる
            if($page_now + $i <= $page_count) $pages[] = $page_now + $i;
            //リンク数がmaxまでくれば終了
            if(count($pages) >= $page_count) break;
            //無限ループ回避
            if($i > 100) break;
        }
        sort($pages);
        return $pages;
    }
}
