<?
/**
 * Etc_Mail_Mime
 * 
 * Etc_MailでMimeメールを送るためのクラス。
 * newはしない。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Mail_Mime
{
    const
        /** @const      string  application/octet-stream */
        TYPE_OCTETSTREAM = 'application/octet-stream',
        /** @const      string  text/plain */
        TYPE_TEXT = 'text/plain',
        /** @const      string  text/html */
        TYPE_HTML = 'text/html',
        /** @const      string  7bit */
        ENCODING_7BIT = '7bit',
        /** @const      string  8bit */
        ENCODING_8BIT = '8bit',
        /** @const      string  quoted-printable */
        ENCODING_QUOTEDPRINTABLE = 'quoted-printable',
        /** @const      string  base64 */
        ENCODING_BASE64 = 'base64',
        /** @const      string  attachment */
        DISPOSITION_ATTACHMENT = 'attachment',
        /** @const      string  inline */
        DISPOSITION_INLINE = 'inline',
        /** @const      int     一行の長さ */
        LINELENGTH = 74,
        /** @const      string  改行コード */
        LINEEND = "\n",
        /** @const      string  multipart/alternative */
        MULTIPART_ALTERNATIVE = 'multipart/alternative',
        /** @const      string  multipart/mixed */
        MULTIPART_MIXED = 'multipart/mixed',
        /** @const      string  multipart/related */
        MULTIPART_RELATED = 'multipart/related';
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * エンコード。
     * @access     public
     * @param      string  $string     文字列
     * @param      string  $encoding   エンコード種類
     * @return     string  エンコードされた文字列
     */
    public static function encode($string, $encoding='mimeheader', $charset='UTF-8')
    {
        switch($encoding){
            case self::ENCODING_BASE64:
                $string = self::encodeBase64($string);
                break;
            case self::ENCODING_7BIT:
            case self::ENCODING_8BIT:
                $string = self::encodeBit($string, $charset);
                break;
            case self::ENCODING_QUOTEDPRINTABLE:
                $string = self::encodeQuotedPrintable($string);
                break;
            case 'mimeheader':
                $string = mb_encode_mimeheader($string);
                break;
        }
        return $string;
    }
    
    
    /**
     * base64エンコード。
     * @access     public
     * @param      string  $string   文字列
     * @return     string  BASE64エンコードされた文字列
     */
    public static function encodeBase64($string, $linelength=self::LINELENGTH, $lineend=self::LINEEND)
    {
        $string = rtrim(chunk_split(base64_encode($string), $linelength, $lineend));
        return $string;
    }
    
    
    /**
     * bitエンコード。
     * @access     public
     * @param      string  $string    文字列
     * @param      string  $charset   文字コード
     * @return     string  エンコードされた文字列
     */
    public static function encodeBit($string, $charset)
    {
        return mb_convert_encoding($string, $charset, Samurai_Config::get('encoding.internal'));
    }
    
    
    /**
     * quoted-printableエンコード。
     * @access     public
     * @param      string  $string   文字列
     * @return     string  quoted-printableエンコードされた文字列
     */
    public static function encodeQuotedPrintable($string)
    {
        return $string;
    }
    
    
    
    
    
    /**
     * デコード。
     * @access     public
     * @param      string  $string     文字列
     * @param      string  $encoding   エンコード種類
     * @return     string  デコードされた文字列
     */
    public static function decode($string, $encoding='mimeheader', $charset='UTF-8')
    {
        switch($encoding){
            case self::ENCODING_BASE64:
                $string = self::decodeBase64($string);
                break;
            case self::ENCODING_7BIT:
            case self::ENCODING_8BIT:
                $string = self::decodeBit($string, $charset);
                break;
            case self::ENCODING_QUOTEDPRINTABLE:
                $string = self::decodeQuotedPrintable($string);
                break;
            case 'mimeheader':
                $string = mb_decode_mimeheader($string);
                break;
            default:
                break;
        }
        return $string;
    }
    
    
    /**
     * base64デコード。
     * @access     public
     * @param      string  $string   文字列
     * @return     string  デコードされた文字列
     */
    public static function decodeBase64($string)
    {
        $string = base64_decode($string);
        return $string;
    }
    
    
    /**
     * bitデコード。
     * @access     public
     * @param      string  $string    文字列
     * @param      string  $charset   文字コード
     * @return     string  デコードされた文字列
     */
    public static function decodeBit($string, $charset)
    {
        return mb_convert_encoding($string, Samurai_Config::get('encoding.internal'), $charset);
    }
    
    
    /**
     * quoted-printableデコード。
     * @access     public
     * @param      string  $string   文字列
     * @return     string  quoted-printableデコードされた文字列
     */
    public static function decodeQuotedPrintable($string)
    {
        return $string;
    }
}
