<?
/**
 * Etc_Mail_Template
 * 
 * メール用テンプレートクラス。
 * Rendererを使用して、メールに情報をセットする。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @see        Samurai_Rednerer
 * @see        Etc_Mail_Mime_Decoder
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass('Etc_Mail_Mime_Decoder');
class Etc_Mail_Template
{
    public
        /** @var        string  テンプレートディレクトリのprefix */
        $prefix = 'mail',
        /** @var        object  Etc_Mail_Mime_Decoder */
        $Decoder,
        /** @var        object  Samurai_Rednerer */
        $Renderer;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        $this->Decoder = new Etc_Mail_Mime_Decoder();
    }
    
    
    
    
    
    /**
     * 変数を割り当てる。
     * @access     public
     * @param      string  $key     キー
     * @param      mixed   $value   値
     */
    public function assign($key, $value)
    {
        $this->Renderer->assign($key, $value);
    }
    
    
    /**
     * 指定されたテンプレートを描画してデコードする。
     * @access     public
     * @param      string  $template   テンプレート
     */
    public function render($template)
    {
        $mail_text = $this->_fetch($template);
        $Mail = $this->_decode($mail_text);
        return $Mail;
    }
    
    
    
    
    
    /**
     * テンプレートファイルを解釈する。
     * @access     public
     * @param      string  $template   テンプレート
     */
    public function _fetch($template)
    {
        $template = $this->prefix.'/'.$template;
        $mail_text = $this->Renderer->render($template);
        return $mail_text;
    }
    
    
    /**
     * メール本文をデコード。
     * @access     private
     * @param      string  $mail_text   メール本文
     */
    private function _decode($mail_text)
    {
        $this->_adjustText($mail_text);
        $Mail = $this->Decoder->decode($mail_text);
        return $Mail;
    }
    
    
    
    
    
    /**
     * メール本文を調節する。
     * Content-Typeの付加など。
     * @access     private
     * @param      string  &$mail_text
     */
    private function _adjustText(&$mail_text)
    {
        //エンコード
        $this->_encodeHeader($mail_text);
        //Content-Typeの付加
        if(!$this->_hasHeader('content-type', $mail_text)){
            $content_type = sprintf('%s; charset="%s"', Etc_Mail_Mime::TYPE_TEXT, Samurai_Config::get('encoding.template'));
            $this->_intractHeader('content-type', $content_type, $mail_text);
        }
        //Content-Transfer-Encodingの付加
        if(!$this->_hasHeader('content-transfer-encoding', $mail_text)){
            $this->_intractHeader('content-transfer-encoding', Etc_Mail_Mime::ENCODING_8BIT, $mail_text);
        }
    }
    
    
    /**
     * ヘッダー部分をエンコードする。
     * @access     private
     * @param      string  &$mail_text   メール本文
     */
    private function _encodeHeader(&$mail_text)
    {
        $headers = array();
        if($this->_existsHeader($mail_text)){
            list($header, $mail_text) = $this->_splitText($mail_text);
            $headers = explode(Etc_Mail_Mime_Part::LINEEND, $header);
        }
        foreach($headers as $_i => $header){
            list($_key, $_value) = preg_split('/\s*:\s*/', trim($header));
            $headers[$_i] = sprintf('%s : %s', $_key, Etc_Mail_Mime::encode($_value));
        }
        $header = join(Etc_Mail_Mime_Part::LINEEND, $headers);
        $mail_text = join(Etc_Mail_Mime_Part::LINEEND, array($header, '', $mail_text));
    }
    
    
    /**
     * メール本文が指定のヘッダーらしきものを保持しているかどうか？
     * @access     private
     * @param      string  $key         キー
     * @param      string  $mail_text   メール本文
     * @return     boolean 指定のヘッダーを保持しているかどうか
     */
    private function _hasHeader($key, $mail_text)
    {
        if($this->_existsHeader($mail_text)){
            list($header, $body) = $this->_splitText($mail_text);
            foreach(explode(Etc_Mail_Mime_Part::LINEEND, $header) as $header){
                $headers = preg_split('/\s*:\s*/', trim($header));
                if(strtolower($key) == strtolower($headers[0])){
                    return true;
                }
            }
        }
        return false;
    }
    
    
    /**
     * ヘッダー部分が存在するのかどうか。
     * @access     private
     * @param      string  $mail_text   メール本文
     * @return     boolean ヘッダー部分が存在するのか
     */
    private function _existsHeader($mail_text)
    {
        list($header) = $this->_splitText($mail_text);
        $headers = explode(Etc_Mail_Mime_Part::LINEEND, $header);
        foreach($headers as $header){
            if(!preg_match('/^\s+/', $header) && !preg_match('/:/', $header)){
                return false;
            }
        }
        return (bool)$headers;
    }
    
    
    /**
     * ヘッダーを埋め込む。
     * @access     private
     * @param      string  $key          キー
     * @param      mixed   $value        値
     * @param      string  &$mail_text   メール本文
     */
    private function _intractHeader($key, $value, &$mail_text)
    {
        $headers = array();
        if($this->_existsHeader($mail_text)){
            list($header, $mail_text) = $this->_splitText($mail_text);
            $headers = explode(Etc_Mail_Mime_Part::LINEEND, $header);
        }
        array_push($headers, "{$key} : {$value}");
        $header = join(Etc_Mail_Mime_Part::LINEEND, $headers);
        $mail_text = join(Etc_Mail_Mime_Part::LINEEND, array($header, '', $mail_text));
    }
    
    
    /**
     * メール本文をヘッダー部分と、本文部分に分ける。
     * @access     private
     * @param      string  $mail_text
     * @return     array   ヘッダー部分と本文部分
     */
    private function _splitText($mail_text)
    {
        return explode(Etc_Mail_Mime_Part::LINEEND.Etc_Mail_Mime_Part::LINEEND, $mail_text, 2);
    }
}
