<?
/**
 * Etc_Mail_Transporter
 * 
 * Etc_Mailの送信担当者。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
abstract class Etc_Mail_Transporter
{
    protected
        /** @var        object  Etc_Mail */
        $Mail,
        /** @var        object  TOPパート */
        $Part,
        /** @var        array   header */
        $_header = array(),
        /** @var        string  body */
        $_body,
        /** @var        string  受取人 */
        $_recipients;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 送信トリガー。
     * @access     public
     * @param      object  $Mail   Etc_Mail
     */
    public function send(Etc_Mail $Mail)
    {
        //初期化
        $this->Mail = $Mail;
        if(!$Mail->hasContent()){
            throw new Samurai_Exception("Unsetted bodies or attaches");
        }
        //TOPパートの構築
        $this->Part = new Etc_Mail_Mime_Part();
        foreach($this->Mail->getBodies() as $Body){
            $this->Part->addPart($Body);
        }
        foreach($this->Mail->getAttaches() as $Attach){
            $this->Part->addPart($Attach);
        }
        //送信
        $this->_generateHeader();
        $this->_generateBody();
        $this->_send();
    }
    
    
    /**
     * 抽象送信トリガー。
     * 各Transporterで実装してください。
     * @access     protected
     */
    protected abstract function _send();
    
    
    /**
     * ヘッダーを生成する。
     * @access     private
     */
    private function _generateHeader()
    {
        $this->_header = $this->Mail->getHeaders();
        //To,Cc,Bcc
        foreach($this->Mail->getRecipients() as $type => $recipients){
            foreach($recipients as $Recipient){
                if(!$this->_recipients){
                    $this->_recipients = $Recipient->toString(true);
                } else {
                    $this->_recipients .= ', '.$Recipient->toString(true);
                }
                if(!isset($this->_header[$type])){
                    $this->_header[$type] = $Recipient->toString(true);
                } else {
                    $this->_header[$type] .= ', '.$Recipient->toString(true);
                }
            }
        }
        //From
        $this->_header['from'] = $this->Mail->getFrom()->toString(true);
        //Subject
        $this->_header['subject'] = $this->Mail->getSubject(true);
    }
    
    
    /**
     * メッセージボディを生成する。
     * @access     private
     */
    private function _generateBody()
    {
        $this->_header += $this->Part->getHeaders(true);
        $this->_body = $this->Part->getContent();
    }
}
