<?
/**
 * Etc_Mail_Mime_Decoder
 * 
 * メール解析用クラス。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass('Etc_Mail');
class Etc_Mail_Mime_Decoder
{
    private
        /** @var        string  メールアドレス正規表現 */
        $_pattern_mail = '[a-zA-Z0-9_\-\.\?\+\/"]+@(\[)?[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,4}|[0-9]{1,3})(\])?';
    
    
    /**
     * コンストラクタ。
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * デコードトリガ。
     * @access     public
     * @param      string  $mail_text   メール全文
     */
    public function decode($mail_text)
    {
        //Mailインスタンス生成
        $Mail = new Etc_Mail();
        //デコード
        $Part = $this->_decode($mail_text);
        if($Part->isText()){
            $Mail->setBody($Part);
        } else {
            $Mail->addAttachment($Part);
        }
        //その他
        $this->_decodeRecipients($Mail, $Part);
        $this->_decodeOthers($Mail, $Part);
        return $Mail;
    }
    
    
    /**
     * メインデコード処理。
     * @access     private
     * @param      string  $mail_text   メール本文
     * @return     object  Etc_Mail_Mime_Part
     */
    private function _decode($mail_text)
    {
        //初期化
        $Part = new Etc_Mail_Mime_Part();
        //ヘッダー部分を抜き出す
        $headers = $this->_extractHeaders($mail_text);
        $this->_intractHeaders($Part, $headers);
        //本文を抜き出す
        if($Part->isMultipart()){
            $parts = $this->_extractParts($mail_text, $Part->boundary);
            foreach($parts as $part_text){
                $Part->addPart($this->_decode($part_text));
            }
        } else {
            $Part->content = Etc_Mail_Mime::decode($mail_text, $Part->encoding, $Part->charset);
        }
        return $Part;
    }
    
    
    /**
     * メール本文からヘッダー部分を抜き出す。
     * @access     private
     * @param      string  &$mail_text
     * @return     array   headers
     */
    private function _extractHeaders(&$mail_text)
    {
        //とりあえず改行で区切る
        $texts = explode(Etc_Mail_Mime_Part::LINEEND, $mail_text);
        //ヘッダー部分を取得する
        $headers = array();
        while($header = array_shift($texts)){
            if($header == '') break;
            if(isset($_key) && preg_match('/^\s+/', $header)){
                $headers[$_key] .= Etc_Mail_Mime::decode($header);
            }elseif(preg_match('/^.*?:.*$/', $header)){
                list($_key, $_val) = preg_split('/\s*:\s*/', ltrim($header));
                $headers[$_key] = Etc_Mail_Mime::decode($_val);
            } else {
                array_unshift($texts, $header);
                break;
            }
        }
        //その他の部分を本文に
        $mail_text = join(Etc_Mail_Mime_Part::LINEEND, $texts);
        return $headers;
    }
    
    
    /**
     * ヘッダーをPartに埋め込む。
     * ヘッダーではなくプロパティへ埋め込む項目も考慮。
     * @access     private
     * @param      object  $Part      Etc_Mail_Mime_Part
     * @param      string  $headers   ヘッダー
     */
    private function _intractHeaders($Part, $headers=array())
    {
        //埋め込み
        foreach($headers as $key => $value){
            switch(strtolower($key)){
                case 'content-transfer-encoding':
                    $Part->encoding = $value;
                    break;
                case 'content-type':
                    $values = preg_split('/\s*;\s*/', trim($value));
                    $Part->type = array_shift($values);
                    foreach($values as $value){
                        $value = str_replace('"', '', $value);
                        if(preg_match('/charset=(.*)/', $value, $matches)){
                            $Part->charset = $matches[1];
                        } elseif(preg_match('/boundary=(.*)/', $value, $matches)){
                            $Part->boundary = $matches[1];
                        }
                    }
                    break;
                default:
                    $Part->setHeader($key, $value);
                    break;
            }
        }
    }
    
    
    
    /**
     * 宛先をデコードする。
     * @access     private
     * @param      object  Etc_Mail
     * @param      object  Etc_Mail_Mime_Part
     */
    public function _decodeRecipients($Mail, $Part)
    {
        //To:
        if($Part->hasHeader('to')){
            $addresses = preg_split('/\s*,\s*/', $Part->getHeader('to'));
            foreach($addresses as $address) $Mail->addTo($this->_decodeAddress($address));
            $Part->delHeader('to');
        }
        //Cc:
        if($Part->hasHeader('cc')){
            $addresses = preg_split('/\s*,\s*/', $Part->getHeader('cc'));
            foreach($addresses as $address) $Mail->addTo($this->_decodeAddress($address));
            $Part->delHeader('cc');
        }
        //Bcc:
        if($Part->hasHeader('bcc')){
            $addresses = preg_split('/\s*,\s*/', $Part->getHeader('bcc'));
            foreach($addresses as $address) $Mail->addTo($this->_decodeAddress($address));
            $Part->delHeader('bcc');
        }
    }
    
    
    /**
     * アドレス文字列をデコードする。
     * @access     private
     * @param      string  $address
     * @return     object  Etc_Mail_Address
     */
    private function _decodeAddress($address)
    {
        $Address = new Etc_Mail_Address();
        //メールのみ
        if(preg_match("/\s*?({$this->_pattern_mail})\s*?$/", $address, $matches)){
            $Address->mail = trim($matches[1]);
        }
        //コメント内
        elseif(preg_match("/(.*?)\s*?<({$this->_pattern_mail})>\s*?$/", $address, $matches)){
            $Address->mail = $matches[2];
            $Address->name = $matches[1];
        }
        return $Address;
    }
    
    
    /**
     * その他のものをデコードする。
     * @access     private
     * @param      object  $Mail   Etc_Mail
     * @param      object  $Part   Etc_Mail_Mime_Part
     */
    private function _decodeOthers($Mail, $Part)
    {
        //From:
        $Mail->setFrom($this->_decodeAddress($Part->getHeader('from')));
        $Part->delHeader('from');
        //Subject:
        $Mail->setSubject($Part->getHeader('subject'));
        $Part->delHeader('subject');
        //その他
        foreach($Part->getHeaders() as $_key => $_val){
            $Part->delHeader($_key);
            $Mail->setHeader($_key, $_val);
        }
    }
    
    
    
    
    
    
    
    /**
     * Fromの分解。
     * @access     private
     */
    private function _decodeFrom()
    {
        if(!isset($this->structure->headers['from'])) return false;
        $this->_from = $this->_parseMail($this->structure->headers['from']);
    }
    /**
     * 件名のデコード。
     * @access     private
     */
    private function _decodeSubject()
    {
        if(!isset($this->structure->headers['subject'])) return false;
        $this->_subject = $this->_convertEncoding($this->structure->headers['subject'], Samurai_Config::get("code.internal"),
                                        "JIS,UTF-8,EUC-JP,SJIS", $this->_params['decode_headers']);
    }
    /**
     * 本文のデコード。
     * @access     private
     */
    private function _decodeBody()
    {
        if(isset($this->structure->body)){
            if(isset($this->structure->ctype_parameters['charset'])){
                $this->_body = $this->_convertEncoding($this->structure->body, Samurai_Config::get("code.internal"),
                                            $this->structure->ctype_parameters['charset'], $this->_params['decode_bodies']);
            } else {
                $this->_body = $this->_convertEncoding($this->structure->body, Samurai_Config::get("code.internal"),
                                            "JIS,UTF-8,EUC-JP,SJIS", $this->_params['decode_bodies']);
            }
        } elseif(isset($this->structure->parts)){
            foreach($this->structure->parts as $part){
                if($part->ctype_primary=="text"){
                    $this->_body = $this->_convertEncoding($part->body, Samurai_Config::get("code.internal"),
                                                $part->ctype_parameters['charset'], $this->_params['decode_bodies']);
                    break;
                }
            }
        }
    }
    /**
     * 添付ファイルのデコード。
     * @access     private
     */
    private function _decodeAttach()
    {
        if(isset($this->structure->parts)){
            foreach($this->structure->parts as $part){
                if($part->ctype_primary != "text"){
                    $Attach = new Tool_Mail_Mime_Part($part->body);
                    $Attach->ctype = "{$part->ctype_primary}/{$part->ctype_secondary}";
                    $Attach->encoding = $part->headers['content-transfer-encoding'];
                    $Attach->disposition = $part->disposition;
                    if(isset($part->ctype_parameters['name'])){
                        $Attach->filename = $this->_convertEncoding($part->ctype_parameters['name'], Samurai_Config::get("code.internal"),
                                                        "JIS,UTF-8,EUC-JP,SJIS", $this->_params['decode_headers']);
                    }
                    if(isset($part->headers['content-id'])) $Attach->id = $part->headers['content-id'];
                    $this->_attach[] = $Attach;
                }
            }
        }
    }
    
    
    
    
    
    /**
     * Toを取得。
     * @access     public
     */
    public function getTo($with_name=false, $index=0)
    {
        if(!$this->_to || !isset($this->_to[$index])) return false;
        return $with_name ? $this->_to[$index] : $this->_to[$index]['mail'] ;
    }
    /**
     * Fromを取得する。
     * @access     public
     */
    public function getFrom($with_name=false)
    {
        if(!$this->_from) return false;
        return $with_name ? $this->_from : $this->_from['mail'] ;
    }
    /**
     * 件名を取得する。
     * @access     public
     */
    public function getSubject()
    {
        return $this->_subject;
    }
    /**
     * 本文を取得する。
     * @access     public
     */
    public function getBody()
    {
        return $this->_body;
    }
    /**
     * 添付ファイルを全て取得する。
     * @access     public
     */
    public function getAttaches()
    {
        return $this->_attach;
    }
    /**
     * Headersを取得。
     * @access     public
     */
    public function getHeaders()
    {
        return $this->structure->headers;
    }
    
    
    
    
    
    /**
     * コメントつきのなどのメールアドレス部分を分解する。
     * @access     private
     */
    private function _parseMail($mail_str)
    {
        $mail = $name = "";
        //コメント内
        if(preg_match("/(.*?)\s*?<({$this->_pattern_mail})>\s*?$/", $mail_str, $matches)){
            $name = $this->_convertEncoding(trim($matches[1]), Samurai_Config::get("code.internal"), "JIS,UTF-8,EUC-JP,SJIS", $this->_params['decode_headers']);
            $mail = trim($matches[2]);
        //メールのみ
        } elseif(preg_match("/\s*?({$this->_pattern_mail})\s*?$/", $mail_str, $matches)){
            $mail = trim($matches[1]);
        }
        return array("name"=>$name, "mail"=>$mail);
    }
    
    
    
    
    /**
     * 文字コードを内部用に変換する。
     * @access     private
     * @param      string  $string      文字列
     * @param      string  $to_code     変更後のコード
     * @param      string  $from_code   変更前のコード
     * @param      boolean $decoded     mimeデコードしてあるかどうか
     */
    private function _convertEncoding($string, $to_code, $from_code, $decoded=false)
    {
        if($decoded){
            $string = mb_convert_encoding($string, $to_code, $from_code);
        } else {
            $string = mb_convert_encoding(mb_decode_mimeheader($string), $to_code);
        }
        return $string;
    }
    
    
    
    
    
    /**
     * 初期化。
     * @access     public
     */
    public function clear()
    {
        $this->mail_text = '';
        $_to = array();
        $_cc = array();
        $_bcc = array();
        $_from = NULL;
        $_subject = '';
        $this->Part = NULL;
    }
}
