<?
/**
 * Etc_Mail_Mime_Part
 * 
 * Etc_MailでMime_Part。
 * Mime_PartはMime_Partを格納する事が可能である。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Mail_Mime_Part
{
    public
        /** @var        mixed   内容 */
        $content,
        /** @var        string  Content-Type */
        $type = Etc_Mail_Mime::TYPE_OCTETSTREAM,
        /** @var        string  Encoding */
        $encoding = Etc_Mail_Mime::ENCODING_7BIT,
        /** @var        string  文字コード */
        $charset,
        /** @var        string  Content-Disposition */
        $disposition,
        /** @var        string  ファイル名 */
        $filename,
        /** @var        string  ID */
        $id,
        /** @var        string  バウンダリー */
        $boundary;
    private
        /** @var        array   Etc_Mail_Mime_Part格納 */
        $_parts = array(),
        /** @var        array   ヘッダー格納 */
        $_headers = array();
    const
        /** @const      string  改行コード */
        LINEEND = "\r\n";
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct($content=NULL)
    {
        $this->content = $content;
        $this->boundary = 'BOUNDARY_'.md5(uniqid(rand(), true));
    }
    
    
    
    
    
    /**
     * パートを追加する。
     * @access     public
     * @param      object  $Part   Etc_Mail_Mime_Part
     */
    public function addPart(Etc_Mail_Mime_Part $Part)
    {
        $this->_parts[] = $Part;
        if($this->isMultipart()){
            if($Part->type == Etc_Mail_Mime::TYPE_HTML){
                $this->type = Etc_Mail_Mime::MULTIPART_ALTERNATIVE;
            } else {
                $this->type = Etc_Mail_Mime::MULTIPART_MIXED;
            }
        }
    }
    
    
    /**
     * パートを取得する。
     * @access     public
     */
    public function fetchPart($pindex=NULL)
    {
        static $index = 0;
        if($pindex) $index = $pindex - 1;
        if(isset($this->_parts[$index])){
            $Part = $this->_parts[$index];
            $index++;
            return $Part;
        } else {
            $index = 0;
            return NULL;
        }
    }
    
    
    /**
     * ヘッダーをセットする。
     * @access     public
     * @param      string  $key     キー
     * @param      string  $value   値
     */
    public function setHeader($key, $value)
    {
        $key = strtolower($key);
        $this->_headers[$key] = $value;
    }
    /**
     * ヘッダーを取得する。
     * @access     public
     * @param      string  $key   キー
     */
    public function getHeader($key)
    {
        $key = strtolower($key);
        return $this->hasHeader($key) ? $this->_headers[$key] : NULL ;
    }
    /**
     * ヘッダーを削除する。
     * @access     public
     * @param      string  $key   キー
     */
    public function delHeader($key)
    {
        $key = strtolower($key);
        if(isset($this->_headers[$key])) unset($this->_headers[$key]);
    }
    /**
     * ヘッダーがあるかどうか。
     * @access     public
     * @param      string  $key   キー
     */
    public function hasHeader($key)
    {
        return isset($this->_headers[$key]);
    }
    
    
    /**
     * ヘッダーを全て取得する。
     * @access     public
     * @return     array   headers
     */
    public function getHeaders($all=false)
    {
        $headers = $this->_headers;
        if($all){
            if($this->isMultipart()){
                $headers['content-type'] = $this->type.'; boundary="'.$this->boundary.'"';
                if($this->encoding){
                    $headers['content-transfer-encoding'] = $this->encoding;
                }
            } else {
                $Part = $this->_parts ? $this->_parts[0] : $this ;
                $headers['content-type'] = $Part->type;
                if($Part->charset){
                    $headers['content-type'] .= '; charset="'.$Part->charset.'"';
                }
                if($Part->filename){
                    $headers['content-type'] .= '; name="'.Etc_Mail_Mime::encode($Part->filename).'"';
                }
                if($Part->disposition){
                    $headers['content-disposition'] = Etc_Mail_Mime::encode($Part->disposition);
                    if($Part->filename){
                        $headers['content-disposition'] .= '; filename="'.Etc_Mail_Mime::encode($Part->filename).'"';
                    }
                }
                if($Part->encoding){
                    $headers['content-transfer-encoding'] = $Part->encoding;
                }
                if($Part->id){
                    $headers['content-id'] = '<'.$Part->id.'>';
                }
            }
        }
        return $headers;
    }
    
    
    /**
     * 内容を取得する。
     * @access     public
     * @return     string  メッセージボディ
     */
    public function getContent()
    {
        if($this->isMultipart()){
            $contents = array();
            foreach($this->_parts as $Part){
                $contents[] = '--'.$this->boundary;
                foreach($Part->getHeaders(true) as $key => $value){
                    $key = join('-', array_map('ucfirst', explode('-', $key)));
                    $contents[] = "{$key}: {$value}";
                }
                $contents[] = '';
                $contents[] = $Part->getContent();
            }
            $contents[] = '--'.$this->boundary.'--';
            return join(self::LINEEND, $contents);
        } else {
            $Part = $this->_parts ? $this->_parts[0] : $this ;
            return Etc_Mail_Mime::encode($Part->content, $Part->encoding, $Part->charset);
        }
    }
    
    
    
    
    
    /**
     * ストリーム判断。
     * @access     public
     * @return     boolean ストリームかどうか
     */
    public function isStream()
    {
        return is_resource($this->content);
    }
    
    
    /**
     * マルチかどうか。
     * @access     public
     * @return     boolean マルチパートかどうか
     */
    public function isMultipart()
    {
        return count($this->_parts) > 1;
    }
    
    
    /**
     * テキストかどうか。
     * @access     public
     * @return     boolean テキストかどうか
     */
    public function isText()
    {
        return preg_match('|^text/.+|', $this->type);
    }
}
