<?
/**
 * Filter_Debug
 * 
 * デバッグ情報を表示するFilter。
 * dBugクラスを使用したデバッガ。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 */
Samurai_Loader::loadByClass('Filter_Debug_Debugger');
class Filter_Debug extends Samurai_Filter
{
    private
        /** @var        array   デバッガ */
        $_debuggers = array(),
        /** @var        array   表示する内容 */
        $_list = array(),
        /** @var        array   ログの保管場所 */
        $_logs = array(),
        /** @var        array   クエリーの保管場所 */
        $_queries = array(),
        /** @var        boolean デバッグ判断 */
        $_is_debug = false,
        /** @var        boolean エラーが発生しているかどうか */
        $_has_error = false;
    public
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  Cookieコンポーネント */
        $Cookie,
        /** @var        object  Sessionコンポーネント */
        $Session,
        /** @var        object  Deviceコンポーネント */
        $Device,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain,
        /** @var        object  FilterChainコンポーネント */
        $FilterChain,
        /** @var        object  Rendererコンポーネント */
        $Renderer;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        foreach($this->getAttributes() as $_key => $_val){
            switch($_key){
                case 'ip':
                case 'agent':
                case 'cookie':
                    $this->{'_isDebugFrom'.ucfirst(strtolower($_key))}($_val);
                    break;
            }
            if($this->_is_debug) break;
        }
        //debugging = 'all'やtrueの場合はdebugｴﾗｰの格納
        if($this->getAttribute('debugging') === 'all'
            || (!$this->_is_debug && $this->getAttribute('debugging'))){
            $ErrorList = $this->ActionChain->getCurrentErrorList();
            $ErrorList->setType(Samurai_Config::get('error.debug'));
        }
    }
    
    
    /**
     * IPからﾃﾞﾊﾞｯｸﾞ判断。
     * @access     private
     */
    private function _isDebugFromIp($ip)
    {
        if(in_array($_SERVER['REMOTE_ADDR'], (array)$ip)){
            $this->_is_debug = true;
            Samurai_Logger::debug('[Filter_Debug] Auth success by ip. -> %s', array($_SERVER['REMOTE_ADDR']));
        }
    }
    /**
     * USER-AGENTからﾃﾞﾊﾞｯｸﾞ判断。
     * @access     private
     */
    private function _isDebugFromAgent($agent)
    {
        foreach((array)$agent as $_val){
            $_val = preg_quote($_val, '/');
            if(preg_match("/{$_val}/", $this->Request->getHeader('User-Agent'))){
                $this->_is_debug = true;
                Samurai_Logger::debug('[Filter_Debug] Auth success by user-agent. -> %s', array($this->Request->getHeader('User-Agent')));
                return;
            }
        }
    }
    /**
     * Cookieからﾃﾞﾊﾞｯｸﾞ判断。
     * @access     private
     */
    private function _isDebugFromCookie($cookie)
    {
        if(!is_object($this->Cookie)) return;
        foreach((array)$cookie as $_val){
            if($this->Cookie->getParameter($_val)){
                $this->_is_debug = true;
                Samurai_Logger::debug('[Filter_Debug] Auth success by cookie -> %s', array($this->Cookie->getParameter($_val)));
                return;
            }
        }
    }
    
    
    
    
    
    
    /**
     * postfilter
     * デバッグ情報の生成、表示を行う。
     * @override
     */
    protected function _postfilter()
    {
        parent::_postfilter();
        if(!$this->_showWindow()) return;
        //デバッガーのセットアップ
        $this->_setupDebuggers();
        //表示
        $this->_print();
    }
    
    
    
    
    
    /**
     * デバッグウインドウを表示させるかどうか。
     * @access     private
     * @return     boolean デバッグウインドウを表示させるかどうか
     */
    private function _showWindow()
    {
        if(!$this->_is_debug) return false;
        if(!$this->ActionChain->isLast()) return false;
        //明示的にデバッグコンソールを表示したくない場合、動作させない
        if($this->getAttribute('debug_console') === false) return false;
        if($this->Request->getParameter('debug_console') !== NULL){
            if(!$this->Request->getParameter('debug_console')){
                if($this->Cookie) $this->Cookie->setParameter('SAMURAI.Filter.Debug.console', '0');
                return false;
            } else {
                if($this->Cookie) $this->Cookie->setParameter('SAMURAI.Filter.Debug.console', '1');
            }
        }
        if(is_object($this->Cookie) && $this->Cookie->getParameter('SAMURAI.Filter.Debug.console') === '0'){
            return false;
        }
        return true;
    }
    
    
    /**
     * デバッガのセットアップ。
     * @access     private
     */
    private function _setupDebuggers()
    {
        foreach((array)$this->getAttribute('debugger') as $_key => $debugger){
            $Debugger = $this->getDebbuger($debugger);
            $Debugger->setup();
            $Debugger->setIndex($_key);
            $this->_debuggers[] = $Debugger;
            if($Debugger->hasError()) $this->_has_error = true;
        }
    }
    
    
    /**
     * デバッガの取得。
     * @access     public
     * @param      string  $debugger   デバッガ名
     * @return     object  Filter_Debug_Debugger
     */
    public function getDebbuger($debugger)
    {
        $class = sprintf('Filter_Debug_Debugger_%s', ucfirst($debugger));
        $Debugger = Samurai::getContainer()->getComponentByDef($class, new Samurai_Container_Def(array('class'=>$class)));
        return $Debugger;
    }
    
    
    
    
    
    /**
     * 表示する。
     * @access     private
     */
    private function _print()
    {
        Samurai_Loader::load(Samurai_Config::get('directory.library').'/dBug/dBug.php');
        $this->_printCss();
        $this->_printHeader();
        $this->_printMenu();
        $this->_printFooter();
        $this->_printContent();
    }
    
    
    /**
     * ヘッダーを表示する。
     * @access     private
     */
    private function _printHeader()
    {
        echo '<DIV id="samurai_debug_console">';
        echo sprintf('<DIV id="samurai_debug_console_title" class="%s">', $this->_has_error ? 'error' : 'info');
        echo '<DIV style="float:left;">SamuraiFW</DIV>';
        echo '<DIV style="float:right;">';
        foreach($this->_debuggers as $Debugger){
            if($Debugger->position == 'top'){
                echo sprintf(' <IMG src="%s" class="icon" style="%s" onClick="%s">',
                                $Debugger->icon, '', $Debugger->onClick());
            }
        }
        echo sprintf(' <IMG src="/samurai/close.gif" class="icon" onClick="%s">',
                        "document.getElementById('samurai_debug_console').style.display='none';");
        echo '</DIV>';
        echo '<DIV style="clear:both;"></DIV>';
        echo '</DIV>';
    }
    
    
    /**
     * メニューを表示する。
     * @access     private
     */
    private function _printMenu()
    {
        echo sprintf('<DIV id="samurai_debug_console_menu">');
        foreach($this->_debuggers as $Debugger){
            if($Debugger->position == 'menu'){
                echo sprintf('<DIV id="samurai_debug_console_menu_item" class="%s" onMouseOver="%s" onMouseOut="%s" onClick="%s">%s</DIV>',
                                $Debugger->hasError() ? 'error' : 'item',
                                "this.style.color='#FFFFFF';",
                                "this.style.color='#333333';",
                                $Debugger->onClick(),
                                $Debugger->icon);
            }
        }
        echo '</DIV>';
    }
    
    
    /**
     * フッターを表示する。
     * @access     private
     */
    private function _printFooter()
    {
        
        foreach($this->_debuggers as $Debugger){
            if($content = $Debugger->getFooterContent()){
                echo '<DIV class="samurai_debug_console_footer_item">';
                echo $content;
                echo '</DIV>';
            }
        }
        echo '<DIV id="samurai_debug_console_footer">';
        echo '&copy; BEFOOL,Inc.';
        echo '</DIV>';
        echo '</DIV>';
    }
    
    
    /**
     * CSSを表示する。
     * @access     private
     */
    private function _printCss()
    {
        //CSS
        echo '<STYLE type="text/css">';
        echo file_get_contents(dirname(__FILE__).'/debug/debug.css');
        echo '</STYLE>';
        //JS
        echo '<SCRIPT type="text/javascript">';
        echo file_get_contents(dirname(__FILE__).'/debug/debug.js');
        echo '</SCRIPT>';
    }
    
    
    /**
     * 内容を表示する。
     * @access     private
     */
    private function _printContent()
    {
        foreach($this->_debuggers as $Debugger){
            echo $Debugger->getContent();
        }
    }
    
    
    
    
    
    
    /**
     * Query項目の追加。
     * @access     private
     */
    private function _addConsoleMenuQuery()
    {
        if(class_exists("ActiveGatewayManager")){
            $this->_queries = ActiveGatewayManager::getPoolQuery();
        }
        foreach($this->_queries as $_key => $query){
            $query['error'] = $query['time'] > 0.5;
            $query['image'] = sprintf('<IMG src="/samurai/%s">', $query['error'] ? 'error.gif' : 'info.gif');
            $query['time'] = $query['time'] * 1000;
            $this->_queries[$_key] = $query;
        }
    }
    
    
    /**
     * Log項目の追加。
     * @access     private
     */
    private function _addConsoleMenuLog()
    {
        $messages = Samurai_Logger::getMessages();
        foreach($messages as $_key => $log){
            $time = (!$_key) ? $log['time']-SAMURAI_START : $log['time']-$messages[$_key-1]['time'] ;
            $log['time'] = $time*1000;
            $log['error'] = $log['level'] >= 3;
            $log['image'] = sprintf('<IMG src="/samurai/%s">', $log['error'] ? 'error.gif' : 'info.gif');
            switch($log['level']){
                case 1: $log['level'] = 'debug'; break;
                case 2: $log['level'] = 'info';  break;
                case 3: $log['level'] = 'warn';  break;
                case 4: $log['level'] = 'error'; break;
                case 5: $log['level'] = 'fatal'; break;
            }
            $this->_logs[] = $log;
            if($log['error']) $this->_has_error = true;
        }
    }
}
