<?
/**
 * Filter_ExecutionTime
 * 
 * 実行時間を計測するためのフィルター。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 */
class Filter_ExecutionTime extends Samurai_Filter
{
    public
        /** @var        int     開始時間 */
        $start = 0;
    
    
    /**
     * prefilter
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        $this->start = microtime(true);
    }
    
    
    /**
     * postfilter
     * @override
     */
    protected function _postfilter()
    {
        parent::_postfilter();
        //総合実行時間
        $end  = microtime(true);
        $time = $end - $this->start;
        $name = $this->getAttribute("name");
        Samurai_Logger::info("[%s] %0.1f ms", array($name, $time*1000));
        //SQL実行時間
        $query_time = 0;
        /*
        if(class_exists("ActiveGatewayManager")){
            foreach(ActiveGatewayManager::getPoolQuery() as $query_info){
                $query_time += $query_info['time'];
            }
        }
        */
        //計算
        $this->end = $end;
        $this->time = $time;
        $this->time_php = round($time-$query_time, 4);
        $this->time_sql = round($query_time, 4);
    }
}
