<?
/**
 * Filter_Token
 * 
 * Token処理を行うFilter。
 * 「Token」とは、和訳すると「証拠」という意味であり、
 * 要は、ユーザーかこちらの意図する遷移できたかどうかの証明に使われます。
 * フォームなどの二重投稿禁止などは、このTokenで簡単に処理できます。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Token extends Samurai_Filter
{
    public
        /** @var        object  Tokenコンポーネント */
        $Token,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain,
        /** @var        object  ErrorListコンポーネント */
        $ErrorList;
    private
        /** @var        array   動作モード */
        $_modes = array();
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //Tokenコンポーネントの作成
        $this->_createComponent();
        //Token初期化
        $this->_initToken();
        //処理
        $this->_execute();
    }
    
    
    /**
     * Tokenの検証。
     * @access     private
     */
    private function _execute()
    {
        foreach($this->_modes as $mode){
            switch($mode){
                case 'build':
                    $this->Token->build();
                    break;
                case 'check':
                    if(!$this->Token->check()){
                        $this->ErrorList->setType(Samurai_Config::get("error.token"));
                    }
                    break;
                case 'remove':
                    $this->Token->remove();
                    break;
                default:
                    Samurai_Logger::error("[filter token] invalid mode. -> %s", array($mode));
                    break;
            }
        }
    }
    
    
    
    
    
    /**
     * コンポーネントの生成。
     * @access     private
     */
    private function _createComponent()
    {
        //Token
        $Container = Samurai::getContainer();
        $Container->registerComponent("Token", new Samurai_Container_Def(array("class"=>"Filter_Token_Ticket")));
        $this->Token = $Container->getComponent("Token");
        //ErrorList
        $this->ErrorList = $this->ActionChain->getCurrentErrorList();
    }
    
    
    /**
     * Tokenコンポーネントの初期化。
     * @access     private
     */
    private function _initToken()
    {
        if($this->getAttribute("name")){
            $this->Token->setName($this->getAttribute("name"));
        }
        //モード設定
        if($this->getAttribute("mode")){
            $this->_modes = explode(",", $this->getAttribute("mode"));
            array_walk($this->_modes, "trim");
        } else {
            $this->_modes = array("build");
        }
    }
}
