<?
/**
 * Filter_ViewJson
 * 
 * Json表示を担当するFilter。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
**/
class Filter_ViewJson extends Samurai_Filter
{
    public
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  Responseコンポーネント */
        $Response,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * postfilter.
     * @override
     */
    protected function _postfilter()
    {
        parent::_postfilter();
        //Action結果の取得
        $result = $this->ActionChain->getCurrentActionResult();
        if(Samurai_Config::get('encoding.internal') != 'UTF-8'){
            mb_convert_variables('UTF-8', Samurai_Config::get('encoding.internal'), $result);
        }
        $result = json_encode($result);
        //JSONP(JSON with Padding)コールバックの指定がある場合
        if($this->getAttribute('jsonp') && $Request->getParameter($this->getAttribute('jsonp'))){
            $result = $Request->getParameter($this->getAttribute('jsonp')).'('.$result.');';
        //JSONI(JSON width Iframe)コールバックの指定がある場合
        } elseif($this->getAttribute("jsoni") && $Request->getParameter($this->getAttribute("jsoni"))){
            $function = $Request->getParameter($this->getAttribute("jsoni"));
            //$view = "parent.".$Request->getParameter($this->getAttribute("jsoni"))."(".$view.");";
            $result = join("\r\n", array(
                "<SCRIPT type=\"text/javascript\">",
                "    var result = {$view};",
                "    alert(typeof(parent.document));",
                //"    parent.{$function}(result);",
                "</SCRIPT>",
            ));
        }
        $this->Response->setResult($result);
        //$Response->setContentType("application/json; charset=UTF-8");
    }
}
