<?
/**
 * Filter_ViewSimple
 * 
 * 表示を担当するFilter。
 * Rendererは使用せずにピュアPHPで記述できる。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_ViewSimple extends Samurai_Filter
{
    public
        /** @var        object  Responseコンポーネント */
        $Response,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain,
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  Cookieコンポーネント */
        $Cookie,
        /** @var        object  Sessionコンポーネント */
        $Session,
        /** @var        object  Tokenコンポーネント */
        $Token;
    protected
        /** @var        string  Actionの結果から何を行うかの値(Template|Action|Locationなど) */
        $_do = "Template",
        /** @var        string  _doの内容 */
        $_do_value = "",
        /** @param      string  Actionの結果 */
        $_view = "",
        /** @param      array   Actionの結果その他値 */
        $_view_params = array();
    
    
    /**
     * postfilter.
     * @override
     */
    protected function _postfilter()
    {
        parent::_postfilter();
        //Actionの結果取得
        $this->_setActionResult();
        //処理切り分け
        if($this->_do){
            $method = "_do{$this->_do}";
            if(method_exists($this, $method)){
                $this->$method();
            } else {
                throw new Samurai_Exception("_doメソッドがありません。");
            }
        }
    }
    
    
    
    
    
    /**
     * Location:
     * @access     protected
     */
    protected function _doLocation()
    {
        $this->Response->setRedirect($this->_do_value);
        $this->Response->execute();
    }
    
    
    /**
     * Action:
     * @access     protected
     */
    protected function _doAction()
    {
        $this->ActionChain->add($this->_do_value);
    }
    
    
    /**
     * Template:
     * (default)
     * @access     protected
     */
    protected function _doTemplate()
    {
        if($this->_do_value){
            //解釈
            ob_start();
            $template = Samurai_Loader::getPath(Samurai_Config::get('directory.template').'/'.$this->_do_value);
            include($template);
            $contents = ob_get_contents();
            ob_end_clean();
            //表示
            $Body = $this->Response->setBody($contents);
            if(is_object($Body) && !$this->Response->hasHeader('content-type')){
                $Body->setHeader("content-type", sprintf("text/html; charset=%s", Samurai_Config::get("encoding.output")));
            }
            $this->Response->execute();
        }
    }
    
    
    
    
    
    /**
     * Actionの結果取得。
     * @access     private
     */
    protected function _setActionResult()
    {
        //結果セット
        $result = $this->ActionChain->getCurrentActionResult();
        if(is_array($result)){
            $this->_view = trim(array_shift($result));
            foreach($result as $_key => $_val){
                $this->_view_params[$_key] = $_val;
            }
        } else {
            $this->_view = $result;
        }
        //DOのセット
        if($this->_view){
            $this->_do_value = $this->getAttribute($this->_view);
            if($this->_do_value && preg_match("/^(.+?):(.*?)$/", $this->_do_value, $matches)){
                $this->_do = ucfirst(strtolower($matches[1]));
                $this->_do_value = trim($matches[2]);
            } else {
                $this->_do = "Template";
            }
            if(preg_match_all("/<(.+?)>/", $this->_do_value, $matches, PREG_SET_ORDER)){
                foreach($matches as $_key => $_val){
                    $param_key = $_val[1];
                    if(isset($this->_view_params[$param_key])){
                        $this->_do_value = str_replace("<{$param_key}>", $this->_view_params[$param_key], $this->_do_value);
                    }
                }
            }
            if(!$this->_do_value){
                throw new Samurai_Exception("テンプレートファイルの取得に失敗しました。({$this->_view})");
            }
        }
    }
}
