<?
/**
 * Filter_Auth_Manager
 * 
 * Author処理を管理するクラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Auth
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Auth_Manager
{
    private
        /** @var        array   Authorキャッシュ */
        $_authors = array();
    
    
    /**
     * コンストラクター。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * Authorを取得する。
     * @access     public
     * @param      string  $name   Author名
     * @return     object  Author
     */
    public function getAuthor($name)
    {
        if(!isset($this->_authors[$name])){
            $class = "Filter_Auth_Author_".ucfirst($name);
            Samurai_Loader::loadByClass("Filter_Auth_Author");
            Samurai_Loader::loadByClass($class);
            $this->_authors[$name] = new $class();
            Samurai::getContainer()->injectDependency($this->_authors[$name]);
        }
        return $this->_authors[$name];
    }
    
    
    /**
     * Authを行う。
     * @access    public
     * @param     array   $params   Authの条件が入った配列
     */
    public function execute($params){
        if(!is_array($params) || !$params) return true;
        $type = "";
        $error_type = Samurai_Config::get("error.filter.auth", "auth");
        foreach($params as $_key => $_val){
            switch($_key){
                case 'type':
                case 'error_type':
                    $$_key = (string)$_val; unset($params[$_key]); break;
            }
        }
        
        //Authorの生成
        $Author = $this->_getAuthor($type);
        
        //Authorの実行
        $result = $Author->authorize($params);
        
        //エラー処理
        if($result!==true){
            if($result==Samurai_Config::get("error.filter.login", "login")){
                $result = false;
                $error_type = Samurai_Config::get("error.filter.login", "login");
            }
            $DIContainer = DICOntainerFactory::getContainer();
            $ActionChain = $DIContainer->getComponent("ActionChain");
            $ErrorList   = $ActionChain->getCurrentErrorList();
            if(!$ErrorList->isExists()){
                $ErrorList->setType($error_type);
                if(is_string($result)){
                    $ErrorList->add("authorize", $result);
                }
            }
        }
        
        return true;
    }
}
