<?
/**
 * Filter_Validate_Validator_Date
 * 
 * 日付の妥当性チェック。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Validate_Validator_Date extends Filter_Validate_Validator
{
    /**
     * 日付の妥当性チェック。
     * @implements
     */
    public function validate($value, $params)
    {
        if(is_array($value)){
            $year = array_shift($value);
            $month = array_shift($value);
            $day = array_shift($value);
        } else {
            list($year, $month, $day) = preg_split("/[\-\/\.]/", $value);
        }
        return checkdate($month, $day, $year);
    }
}
