<?
/**
 * Samurai_Config
 * 
 * SamuraiFWの設定情報を管理する。
 * 静的に参照される。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Samurai_Config
{
    private
        /** @var        array   設定情報を保持 */
        static $_config = array();
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * 値の取得。
     * @access     public
     * @param      string  $key       設定キー
     * @param      mixed   $default   デフォルト値
     * @return     mixed   設定値
     */
    public static function get($key, $default=NULL)
    {
        $keys = explode('.', $key);
        $value = $default;
        foreach($keys as $i => $_key){
            if(!$i && isset(self::$_config[$_key])){
                $value = self::$_config[$_key];
            } elseif(is_array($value) && isset($value[$_key])){
                $value = $value[$_key];
            } else {
                $value = $default;
                break;
            }
        }
        return $value;
    }
    
    
    /**
     * 値の設定。
     * @access     public
     * @param      string  $key     設定キー
     * @param      mixed   $value   設定値
     */
    public static function set($key, $value)
    {
        $keys = explode(".", $key);
        $key_str = "";
        foreach($keys as $key){
            $key_str .= (is_numeric($key) || !$key) ? "[{$key}]" : "['{$key}']" ;
        }
        $script = sprintf('self::$_config%s = $value;', $key_str);
        eval($script);
    }
    
    
    /**
     * その値を保持しているかチェック。
     * @access     public
     * @param      string  $key   設定キー
     * @return     boolean その値を保持しているかどうか
     */
    public static function has($key)
    {
        $result = self::get($key);
        return $result !== NULL;
    }
    
    
    /**
     * 設定ファイルから値を取り込む。
     * 設定ファイルが配列構造になっていても「foo.bar」のようにキーは全て文字列として評価される。
     * またそれは配列として読み込むことも可能。
     * @access     public
     * @param      string  $config_file   設定ファイル
     */
    public static function import($config_file)
    {
        $config = Samurai_Yaml::load($config_file);
        self::add($config);
    }
    
    
    /**
     * 配列をまとめて追加する。
     * @access     public
     * @param      array   $config     設定配列
     */
    public static function add(array $config)
    {
        try {
            $Utility = Samurai::getContainer()->getComponent('Utility');
            self::$_config = $Utility->array_merge(self::$_config, $config);
        } catch(Samurai_Exception $E){
            self::$_config = array_merge(self::$_config, $config);
        }
    }
    
    
    /**
     * 設定された値をすべて取得する。
     * @access     public
     * @param      string  $prefix   prefixを指定できる
     * @return     array   検索結果
     */
    public static function getAll($prefix=NULL)
    {
        if($prefix===NULL){
            return self::$_config;
        } else {
            $config = self::get($prefix);
            return (array)$config;
        }
    }
    
    
    /**
     * 初期化。
     * @access     public
     */
    public static function clear()
    {
        self::$_config = array();
    }
}
