<?
/**
 * Samurai_ErrorList
 * 
 * とにかくエラーを格納するためのクラス。
 * 各Actionごとに生成される。
 * 
 * @package    Samurai
 * @subpackage Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 */
class Samurai_ErrorList
{
    private
        /** @var        string  エラータイプ */
        $_type = "",
        /** @var        array   エラー文字列格納 */
        $_list = array();
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * エラー文字列を追加。
     * @access    public
     * @param     string  $key     エラーが発生した項目
     * @param     string  $value   エラー文字列
     */
    public function add($key, $value)
    {
        if(!isset($this->_list[$key])) $this->_list[$key] = array();
        $this->_list[$key][] = $value;
    }
    
    
    /**
     * ErrorListをクリア。
     * @access    public
     */
    public function clear()
    {
        $this->_list = array();
    }
    
    
    /**
     * 現在エラーがあるかどうかを返却。
     * @access     public
     * @return     boolean エラーがあるかどうか
     */
    public function isExists()
    {
        return (bool)$this->_list;
    }
    
    
    /**
     * エラーの種類を返却。
     * @access    public
     * @return    string  エラーの種類
     */
    public function getType()
    {
        return $this->_type;
    }
    
    
    /**
     * エラーの種類を設定。
     * @access    public
     * @param     string  $type   エラーの種類
     */
    public function setType($type)
    {
        if(!$this->_type){
            $this->_type = $type;
        }
    }
    
    
    
    
    
    /**
     * 指定された項目のエラーを返却。
     * @access     public
     * @param      string  $key   エラーキー
     * @return     string  エラー文字列
     */
    public function getMessage($key)
    {
        $message = "";
        if(isset($this->_list[$key])){
            $message = array_shift($this->_list[$key]);
            array_unshift($this->_list[$key], $message);
        }
        return $message;
    }
    
    
    /**
     * 指定された項目の全てのエラーを返却。
     * @access     public
     * @param      string  $key   エラーキー
     * @return     array   エラー配列
     */
    public function getMessages($key)
    {
        return isset($this->_list[$key]) ? $this->_list[$key] : array() ;
    }
    
    
    /**
     * 全てのエラーを一元的に取得する。
     * その際、同一のキーのものはグルーピングされる。(キーは保持される)
     * @access     public
     * @return     array   エラー配列
     */
    public function getAllMessage()
    {
        $messages = array();
        foreach($this->_list as $key => $_val){
            $messages[$key] = $this->getMessage($key);
        }
        return $messages;
    }
    
    
    /**
     * 全てのエラーを一元的に取得する。
     * その際、キーは全て無視される。(キーは保持されない)
     * @access     public
     * @return     array   エラー配列
     */
    public function getAllMessages()
    {
        $messages = array();
        foreach($this->_list as $key => $_val){
            $messages = array_merge($messages, $_val);
        }
        return $messages;
    }
}
