<?
/**
 * Samurai_Renderer.abstract
 * 
 * テンプレートエンジンへのブリッジクラスの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Samurai.Renderer
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Samurai_Renderer
{
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        $this->_setEngine();
    }
    
    
    /**
     * Engineのセット。
     * @access     protected
     */
    abstract protected function _setEngine();
    
    
    /**
     * 初期化メソッド。
     * @access     public
     * @return     string  $init_script
     */
    public function init($init_script=NULL)
    {
        if($init_script !== NULL){
            include(Samurai_Loader::getPath($init_script));
        }
    }
    
    
    /**
     * レンダリング実行。
     * 渡されたファイルを解釈しようとします。
     * @access     public
     * @param      string  $template   テンプレート
     */
    abstract public function render($template);
    
    
    /**
     * 変数の登録。
     * @access     public
     * @param      string  $key     キー
     * @param      mixed   $value   値
     */
    abstract public function assign($key, $value);
    
    
    /**
     * 登録した変数をすべて取得する。
     * @access     public
     * @return     array   アサインされた変数
     */
    abstract public function getAssignedVars();
    
    
    
    
    
    /**
     * ActionのEngineへの登録。
     * @access     public
     * @param      object  $Action   Actionコンポーネント
     */
    abstract public function setAction($Action);
    
    /**
     * RequestのEngineへの登録。
     * @access     public
     * @param      object  $Request   Requestコンポーネント
     */
    abstract public function setRequest($Request);
    
    /**
     * CookieのEngineへの登録。
     * @access     public
     * @param      object  $Cookie   Cookieコンポーネント
     */
    abstract public function setCookie($Cookie);
    
    /**
     * SessionのEngineへの登録。
     * @access     public
     * @param      object  $Session   Sessionコンポーネント
     */
    abstract public function setSession($Session);
    
    /**
     * ServerのEngineへの登録。
     * @access     public
     * @param      array   $server   $_SERVERのEngineへの登録
     */
    abstract public function setServer($server);
    
    /**
     * SCRIPT_NAMEのEngineへの登録。
     * @access     public
     * @param      string  $script_name   $_SERVER['SCRIPT_NAME']
     */
    abstract public function setScriptName($script_name);
    
    /**
     * TokenのEngineへの登録。
     * @access     public
     * @param      object  $Token
     */
    abstract public function setToken($Token);
}
