<?
/**
 * Samurai_Container_Def
 * 
 * コンポーネントの宣言クラス。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Samurai_Container_Def
{
    private
        /** @var        object  インスタンスの保持 */
        $_instance;
    public
        /** @var        string  Alias名 */
        $alias = '',
        /** @var        string  クラス名 */
        $class = '',
        /** @var        array   インスタンスを生成する際の引数 */
        $args = array(),
        /** @var        string  インスタンスタイプ(singleton|prototype) */
        $instance = 'singleton',
        /** @var        string  オートインジェクションのルール(AllowAll|DenyAll) */
        $rule = 'AllowAll',
        /** @var        array   インジェクション許可リスト(DenyAllでも許可される) */
        $allow = array(),
        /** @var        array   インジェクション拒否リスト(AllowAllでも拒否される) */
        $deny = array(),
        /** @var        object  セッターインジェクション情報 */
        $setter = array(),
        /** @var        object  初期化メソッドインジェクション情報 */
        $initMethod;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct(array $define=array())
    {
        //割り当て
        foreach($define as $_key => $_val){
            switch($_key){
                case 'alias':
                case 'class':
                case 'instance':
                case 'rule':
                    $this->$_key = (string)$_val;
                    break;
                case 'args':
                case 'allow':
                case 'deny':
                case 'setter':
                case 'initMethod':
                    $this->$_key = (array)$_val;
                    break;
            }
        }
        //情報の正規化
        $this->validate();
    }
    
    
    
    
    
    /**
     * 情報がvalidateされる。
     * 不正な値はデフォルト値に書き換えられる。
     * @access     public
     */
    public function validate()
    {
        //instance
        if(!in_array($this->instance, array('singleton', 'prototype'))){
            $this->instance = 'singleton';
        }
        //rule
        if(!in_array($this->rule, array('AllowAll', 'DenyAll'))){
            $this->rule = 'AllowAll';
        }
        //initMethod
        if($this->initMethod){
            if(!isset($this->initMethod['name']) || !is_string($this->initMethod['name'])){
                $this->initMethod = NULL;
            } elseif(!is_array($this->initMethod['args'])){
                $this->initMethod['args'] = array();
            }
        }
    }
}
