<?
/**
 * Samurai_Logger_Client_SimpleDisplay
 * 
 * ロガークライアントの一つ。
 * 画面に表示します。
 * 
 * @package    Samurai
 * @subpackage Samurai.Logger.Client
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Logger_Client_SimpleDisplay extends Samurai_Logger_Client
{
    public
        $html = true;
    
    
    /**
     * 設定内容をセット。
     * @access     public
     * @see        Samurai_Logger_Client::define
     */
    public function define(array $define)
    {
        parent::define($define);
        foreach($define as $_key => $_val){
            switch($_key){
                case 'html':
                    $this->$_key = (bool)$_val;
                    break;
            }
        }
    }
    
    
    
    /**
     * トリガーコマンド。
     * @access     public
     * @see        Samurai_Logger_Client::trigger
     */
    public function trigger($level, $message, $file, $line)
    {
        if($this->html){
            echo sprintf("[%s] %s [%s(line%s)]<BR />\r\n", $level, $message, $file, $line);
        } else {
            echo sprintf("[%s] %s [%s(line%s)]\r\n", $level, $message, $file, $line);
        }
    }
}
