<?
/**
 * Samurai_Renderer_Engine_Smarty
 * 
 * Samurai用に拡張されたSmarty。
 * 
 * @package    Samurai
 * @subpackage Samurai.Renderer.Engine
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
include_once('Smarty/Smarty.class.php');
class Samurai_Renderer_Engine_Smarty extends Smarty
{
    public
        /** @var        object  Utilityコンポーネント */
        $Utility;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        parent::__construct();
    }
    
    
    /**
     * テンプレートの解析トリガー。
     * @access     public
     * @param      string  $template   テンプレートファイル
     * @return     string  解釈後のテキスト
     */
    public function fetch($template, $cache_id=null, $compile_id=null, $display=false)
    {
        $this->Utility->fillupDirectory($this->compile_dir);
        $this->Utility->fillupDirectory($this->cache_dir);
        return parent::fetch($template, $cache_id, $compile_id, $display);
    }
    
    
    /**
     * _fetch_resource_info
     * @override
     */
    public function _fetch_resource_info(&$params)
    {
        //template_dirの補完
        if(!Samurai_Loader::isAbsolutePath($params['resource_name'])
            && !Samurai_Loader::isAbsolutePath($this->template_dir)){
            $params['resource_base_path'] = array();
            foreach(Samurai::getSamuraiDirs() as $samurai_dir){
                $params['resource_base_path'][] = $samurai_dir.DS.$this->template_dir;
            }
        }
        return parent::_fetch_resource_info($params);
    }
}
