<?
/**
 * Samurai_Request_Cookie
 * 
 * クッキー値を格納する。
 * 
 * @package    Samurai
 * @subpackage Samurai.Request
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass('Samurai_Request_Parameter');
class Samurai_Request_Cookie extends Samurai_Request_Parameter
{
    private
        /** @var        string  有効パス */
        $_path   = NULL,
        /** @var        string  有効ドメイン */
        $_domain = NULL,
        /** @var        string  有効sequre */
        $_sequre = NULL;
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        $cookie = $_COOKIE;
        //自動エスケープ処理を無効化
        if(get_magic_quotes_gpc()){
            array_walk_recursive($cookie, create_function('&$item', '$item = stripslashes($item);'));
        }
        //文字コードの差異を修正
        if(!ini_get("mbstring.encoding_translation")
            && Samurai_Config::get("encoding.input") != Samurai_Config::get("encoding.internal")){
            mb_convert_variables(Samurai_Config::get("encoding.internal"), Samurai_Config::get("encoding.input"), $cookie);
        }
        //インポート
        $this->import($cookie);
    }
    
    
    
    
    
    /**
     * Cookieの値を格納。
     * 注意すべき点は、expire(有効期限)の値です。
     * 本来のsetcookie関数では、現在の時間も含めた有効期限を指定しなければなりませんが、
     * このメソッドでは、常に現在のUNIX時間に加算されます。
     * その結果、削除ができなくなりますが、その場合、delParameterをご使用下さい。
     * @access     public
     * @param      string  $key          パラメータ名
     * @param      mixed   $value        パラメータの値
     * @param      int     $expire       有効期限
     * @param      string  $path         パス
     * @param      string  $domain       ドメイン
     * @param      int     $sequre       セキュア
     */
    public function setParameter($key, $value, $expire=NULL, $path=NULL, $domain=NULL, $sequre=NULL)
    {
        //配列が渡された場合の配慮
        if(is_array($value)){
            foreach($value as $_key => $_val){
                $new_key = "{$key}.{$_key}";
                $this->setParameter($new_key, $_val, $expire, $path, $domain, $sequre);
            }
            
        //通常の場合
        } else {
            //基本変数の登録
            parent::setParameter($key, $value);
            //cookie独自の登録
            if($expire !== NULL) $expire = date("U")+$expire;
            if($path === NULL)   $path   = $this->getPath();
            if($domain === NULL) $domain = $this->getDomain();
            if($sequre === NULL) $sequre = $this->getSequre();
            $keys = explode(".", $key);
            $base_key = array_shift($keys);
            $key_str  = "";
            foreach($keys as $key){
                $key_str .= "[{$key}]";
            }
            setcookie($base_key.$key_str, $value, $expire, $path, $domain, $sequre);
        }
    }
    public function set($key, $value, $expire=NULL, $path=NULL, $domain=NULL, $sequre=NULL)
    {
        $this->setParameter($key, $value, $expire, $path, $domain, $sequre);
    }
    
    
    /**
     * クッキーの削除。
     * @access     public
     * @param      string  $key   パラメータ名
     */
    public function delParameter($key, $path=NULL, $domain=NULL, $sequre=NULL)
    {
        $value = $this->getParameter($key);
        //配列の場合
        if(is_array($value)){
            foreach($value as $_key => $_val){
                $this->delParameter("{$key}.{$_key}", $path, $domain, $sequre);
            }
            
        //通常の場合
        } else {
            if($path===NULL)   $path   = $this->getPath();
            if($domain===NULL) $domain = $this->getDomain();
            if($sequre===NULL) $sequre = $this->getSequre();
            $keys = explode(".", $key);
            $base_key = array_shift($keys);
            $key_str  = "";
            foreach($keys as $key){
                $key_str .= "[{$key}]";
            }
            setcookie($base_key.$key_str, "", date("U")-60*60, $path, $domain, $sequre);
        }
    }
    public function del($key, $path=NULL, $domain=NULL, $sequre=NULL)
    {
        $this->delParameter($key, $path, $domain, $sequre);
    }
    
    
    
    
    
    /**
     * 有効パスの取得。
     * @access     public
     * @return     string  有効パス
     */
    public function getPath()
    {
        return $this->_path;
    }
    /**
     * 有効パスの設定。
     * @access     public
     * @param      string  $path   有効パス
     */
    public function setPath($path){
        $this->_path = $path;
    }
    
    
    /**
     * 有効ドメインの取得。
     * @access     public
     * @return     string  有効ドメイン
     */
    public function getDomain()
    {
        return $this->_domain;
    }
    /**
     * 有効ドメインの設定。
     * @access     public
     * @param      string  $domain   有効ドメイン
     */
    public function setDomain($domain)
    {
        $this->_domain = $domain;
    }
    
    
    /**
     * HTTPS有効値の取得。
     * @access     public
     * @return     boolean HTTPS有効値
     */
    public function getSequre()
    {
        return $this->_sequre;
    }
    /**
     * HTTPS有効値の設定。
     * @access     public
     * @param      boolean $sequre   HTTPS有効値
     */
    public function setSequre($sequre)
    {
        $this->_sequre = $sequre;
    }
}
