<?
/**
 * Samurai_Request_Parameter.abstract
 * 
 * パラメータ系(Request,Cookie,Sessionなど)の抽象クラス。
 * 基本的なメソッドやインターフェースを提供する。
 * 
 * @package    Samurai
 * @subpackage Samurai.Request
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
abstract class Samurai_Request_Parameter
{
    protected
        /** @var        array   値を格納 */
        $_parameters = array();
    
    
    
    
    
    /**
     * 値のインポート。
     * @access     public
     * @param      array   $parameters   パラメータ値
     */
    public function import(array $parameters)
    {
        $this->_parameters = array_merge($this->_parameters, $parameters);
    }
    
    
    
    
    
    /**
     * 値を取得する。
     * @access     public
     * @param      string  $key   キー
     * @return     mixed   値
     */
    public function getParameter($key)
    {
        $keys = explode(".", $key);
        $parameter = NULL;
        foreach($keys as $_key => $_val){
            if(!$_key && isset($this->_parameters[$_val])){
                $parameter = $this->_parameters[$_val];
            } elseif(is_array($parameter) && isset($parameter[$_val])){
                $parameter = $parameter[$_val];
            } else {
                $parameter = NULL;
            }
        }
        return $parameter;
    }
    /**
     * getParameterのシノニム。
     * @access     public
     * @see        Samurai_Request_Parameter::getParameter
     */
    public function get($key)
    {
        return $this->getParameter($key);
    }
    
    
    /**
     * 全ての値を取得する。
     * @access     public
     * @return     array   全ての値
     */
    public function getParameters()
    {
        return $this->_parameters;
    }
    
    
    /**
     * 値の格納。
     * @access    public
     * @param     string  $key     パラメータ名
     * @param     mixed   $value   パラメータの値
     */
    public function setParameter($key, $value)
    {
        $keys = explode(".", $key);
        $key_str = "";
        foreach($keys as $key){
            $key_str .= (is_numeric($key) || !$key) ? "[{$key}]" : "['{$key}']" ;
        }
        $script = "\$this->_parameters{$key_str} = \$value;";
        eval($script);
    }
    /**
     * setParameterのシノニム。
     * @access     public
     * @see        Samurai_Request_Parameter::setParameter
     */
    public function set($key, $value)
    {
        $this->setParameter($key, $value);
    }
    
    
    /**
     * 値を削除。
     * @access    public
     * @since     1.0.0
     * @param     string  $key   パラメータ名
     */
    public function delParameter($key)
    {
        $keys = explode(".", $key);
        $key_str = "";
        foreach($keys as $key){
            if($key=="") return false;
            $key_str .= (is_numeric($key)) ? "[{$key}]" : "['{$key}']" ;
        }
        $script = "unset(\$this->_parameters{$key_str});";
        eval($script);
    }
    /**
     * delParameterのシノニム。
     * @access     public
     * @see        Samurai_Request_Parameter::delParameter
     */
    public function del($key)
    {
        $this->delParameter($key);
    }
}
