<?
/**
 * Samurai_Request_Upload_File
 * 
 * Requestで受け取ったファイルのDTO。
 * 
 * @package    Samurai
 * @subpackage Samurai.Request
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Request_Upload_File
{
    public
        /** @var        string  名前 */
        $name = '',
        /** @var        string  種類 */
        $type = '',
        /** @var        int     ファイルサイズ */
        $size = 0,
        /** @var        string  ファイルパス */
        $path = '',
        /** @var        string  拡張子 */
        $extension = '',
        /** @var        int     エラーコード */
        $error = UPLOAD_ERR_OK;
    private
        /** @var        array   配列の場合はコチラに格納される */
        $_files = array(),
        /** @var        boolean アップロードされたかどうか */
        $_uploaded = false;
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct($file=array())
    {
        if($file){
            $this->import($file);
        }
    }
    
    
    /**
     * インポート。
     * @access     public
     * @param      array   $_FILEの値
     * @return     object  $this
     */
    public function import($file)
    {
        if(is_array($file['name'])){
            foreach($file['name'] as $_key => $_val){
                $_file = array();
                $_file['name'] = $file['name'][$_key];
                $_file['type'] = $file['type'][$_key];
                $_file['size'] = $file['size'][$_key];
                $_file['tmp_name'] = $file['tmp_name'][$_key];
                $_file['error'] = $file['error'][$_key];
                $this->addFile(new Samurai_Request_Upload_File($_file), $_key);
            }
        } else {
            $pathinfo = pathinfo($file['name']);
            $this->name = $file['name'];
            $this->type = $file['type'];
            $this->size = $file['size'];
            $this->path = $file['tmp_name'];
            $this->error = $file['error'];
            if(isset($pathinfo['extension'])){
                $this->extension = $pathinfo['extension'];
            }
            if($this->error == UPLOAD_ERR_OK){
                $this->_uploaded = true;
            }
        }
    }
    
    
    /**
     * ファイルを追加する。
     * @access     public
     * @param      object  $File   Samurai_Request_Upload_File
     * @param      string  $name   キー
     */
    public function addFile(Samurai_Request_Upload_File $File, $name=NULL)
    {
        if($name){
            $this->_files[$name] = $File;
        } else {
            $this->_files[] = $File;
        }
    }
    
    
    /**
     * ファイルを取得する。
     * @param      string  $name   キー
     * @return     object  Samurai_Request_Upload_File
     */
    public function getFile($name)
    {
        $names = explode('.', $name);
        $basekey = array_shift($names);
        $postfix = join('.', $names);
        if(isset($this->_files[$basekey])){
            if($postfix === ''){
                return $this->_files[$basekey];
            } else {
                return $this->_files[$basekey]->getFile($postfix);
            }
        } else {
            return NULL;
        }
    }
    
    
    /**
     * ファイルを全部取得する。
     * @access     public
     * @return     array   ファイル配列
     */
    public function getFiles()
    {
        return $this->_files;
    }
    
    
    
    
    
    /**
     * ファイルを指定ディレクトリへ移動する。
     * @access     public
     * @param      string  $dest   異動先ファイルパス
     * @return     boolean 移動できたかどうか
     */
    public function move($dest, $mode=0644)
    {
        if(!$this->isArray()){
            $Utility = Samurai::getContainer()->getComponent('Utility');
            $Utility->fillupDirectory(dirname($dest), 0777);
            if(move_uploaded_file($this->path, $dest)){
                $this->path = $dest;
                chmod($this->path, $mode);
                return true;
            }
        }
        return false;
    }
    
    
    /**
     * ファイルのバイナリ文字列を取得する。
     * @access     public
     * @return     string  バイナリ文字列
     */
    public function getString()
    {
        return file_get_contents($this->path);
    }
    
    
    /**
     * ファイルのリソースを取得する。
     * @access     public
     * @param      resource ファイルリソース
     */
    public function getResource()
    {
        return fopen($this->path, 'r');
    }
    
    
    
    
    
    /**
     * アップロードされたかどうか。
     * @access     public
     * @return     boolean アップロードされたかどうか
     */
    public function isUploaded()
    {
        return $this->_uploaded;
    }
    
    
    /**
     * 配列かどうか。
     * @access     public
     * @return     boolean 配列かどうか
     */
    public function isArray()
    {
        return $this->_files;
    }
}
