<?
/**
 * Action_Add_Filter
 * 
 * Filterを生成する。
 * 
 * @package    Samurai
 * @subpackage Generator.Action
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Add_Filter extends Generator_Action
{
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage() || !$this->args) return 'usage';
        //入力チェック
        if(!$this->_checkInput()) return 'usage';
        //ループ(複数指定する事が可能)
        while($filter_name = array_shift($this->args)){
            $filter_name = strtolower($filter_name);
            $filter_file = $this->_addFilter($filter_name);
        }
    }
    
    
    /**
     * 入力チェック。
     * @access     private
     * @return     boolean エラーがあったかどうか
     */
    private function _checkInput()
    {
        //フィルター名のチェック
        foreach($this->args as $filter_name){
            if(!preg_match('/^[a-zA-Z][a-zA-Z0-9_]+?$/', $filter_name)){
                $this->ErrorList->add('filter_name', "{$filter_name} -> Filter's name is Invalid. ([a-zA-Z0-9_])");
            }
        }
        return !$this->ErrorList->isExists();
    }
    
    
    /**
     * フィルターを追加する。
     * @access     private
     * @param      string  $filter_name   フィルター名
     * @param      array   $params        Rendererに渡される値
     */
    private function _addFilter($filter_name, $params=array())
    {
        //Skeletonの決定
        $skeleton = $this->Generator->getSkeleton();
        //Generate
        list($result, $filter_file) = $this->Generator->generate($filter_name, $skeleton, $params);
        //成功
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$filter_name} -> Successfully generated. [{$filter_file}]");
        //既にある
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$filter_name} -> Already exists. [{$filter_file}] -> skip");
        } else {
            $this->_sendMessage("{$filter_name} -> Failed.");
        }
        return $filter_file;
    }
}
