<?
/**
 * Generator_Generator_Action
 * 
 * Action用Generator。
 * 
 * @package    Samurai
 * @subpackage Generator.Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Generator');
class Generator_Generator_Action extends Generator
{
    public
        /** @var        string  Actionスケルトン名 */
        $SKELETON_ACTION = 'action.skeleton.php',
        /** @var        string  YAMLスケルトン名 */
        $SKELETON_YAML = 'action/yaml.skeleton.php',
        /** @var        string  DICONスケルトン名 */
        $SKELETON_DICON = 'action/dicon.skeleton.php',
        /** @var        int     YAML名前空間値(GLOBAL) */
        $YAML_GLOBAL = 1,
        /** @var        int     YAML名前空間値(ACTION) */
        $YAML_ACTION = 2,
        /** @var        int     DICON名前空間値(GLOBAL) */
        $DICON_GLOBAL = 3,
        /** @var        int     DICON名前空間値(ACTION) */
        $DICON_ACTION = 4;
    public
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * Generateトリガーメソッド。
     * @access     public
     * @implements
     */
    public function generate($action_name, $skeleton, $params=array())
    {
        list($class_name, $action_file) = $this->ActionChain->makeNames($action_name);
        //ファイルネームのローカライズ
        $action_file = Samurai_Config::get('generator.directory.samurai').DS.$action_file;
        //ジェネレイト
        $params['class_name'] = $class_name;
        $result = $this->_generate($action_file, $skeleton, $params);
        return array($result, $action_file);
    }
    
    
    
    
    
    /**
     * YAML用のgenerateメソッド。
     * @access     public
     * @param      string  $action_file   Actionファイル
     * @param      string  $skeleton      スケルトン名
     * @param      array   $params        Rendererに渡される値
     * @param      int     $scope         空間値
     * @return     array   結果
     */
    public function generate4Yaml($action_file, $skeleton, $params=array(), $scope=NULL)
    {
        if(!$scope) $scope = $this->YAML_GLOBAL;
        $yaml_file = $this->_getYamlFile($action_file, $scope);
        //ジェネレイト
        $result = $this->_generate($yaml_file, $skeleton, $params);
        return array($result, $yaml_file);
    }
    
    
    /**
     * Yamlファイルパスを取得する。
     * @access     private
     * @param      string  $action_file   Action名
     * @param      int     $scope         空間値
     * @return     string  YAMLパス
     */
    private function _getYamlFile($action_file, $scope)
    {
        //global
        $yaml_file = sprintf('%s/%s', dirname($action_file), Samurai_Config::get('generator.action.config_file'));
        //local
        if($scope === $this->YAML_ACTION){
            $basename = strtolower(array_shift(explode('.', basename($action_file))));
            return sprintf('%s/%s.yml', dirname($action_file), $basename);
        }
        return $yaml_file;
    }
    
    
    
    
    
    /**
     * DICON用のgenerateメソッド。
     * @access     public
     * @param      string  $action_file   Actionファイル
     * @param      string  $skeleton      スケルトン名
     * @param      array   $params        Rendererに渡される値
     * @param      int     $scope         空間値
     * @return     array   結果
     */
    public function generate4Dicon($action_file, $skeleton, $params=array(), $scope=NULL)
    {
        if(!$scope) $scope = $this->DICON_GLOBAL;
        $dicon_file = $this->_getDiconFile($action_file, $scope);
        //ジェネレイト
        $result = $this->_generate($dicon_file, $skeleton, $params);
        return array($result, $dicon_file);
    }
    
    
    /**
     * Diconファイルパスを取得する。
     * @access     private
     * @param      string  $action_file   Action名
     * @param      int     $scope         空間値
     * @return     string  YAMLパス
     */
    private function _getDiconFile($action_file, $scope)
    {
        //global
        $dicon_file = sprintf('%s/%s', dirname($action_file), Samurai_Config::get('generator.action.dicon_file'));
        //local
        if($scope === $this->DICON_ACTION){
            $basename = strtolower(array_shift(explode('.', basename($action_file))));
            return sprintf('%s/%s.dicon', dirname($action_file), $basename);
        }
        return $dicon_file;
    }
    
    
    
    
    
    /**
     * スケルトンの取得。
     * @access     public
     * @param      string  $filename   スケルトン名
     * @return     string  スケルトン名
     */
    public function getSkeleton($filename=NULL)
    {
        if(!$filename) $filename = $this->SKELETON_ACTION;
        return parent::getSkeleton($filename);
    }
}
