<?
/**
 * Generator_Generator_Component
 * 
 * Component用Generator。
 * 
 * @package    Samurai
 * @subpackage Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Generator_Generator_Component extends Generator
{
    public
        /** @var        string  スケルトン名 */
        $SKELETON = 'component.skeleton.php';
    
    
    /**
     * Generateトリガーメソッド。
     * @access     public
     * @param      string  $component_name   コンポーネント名
     * @param      string  $skeleton         スケルトン名
     * @param      array   $params           Rendererに渡される値
     */
    public function generate($component_name, $skeleton, $params=array())
    {
        //ローカライズ
        list($class_name, $file_name) = $this->_makeNames($component_name);
        $component_dir = sprintf('%s/%s', Samurai_Config::get('generator.directory.samurai'), Samurai_Config::get('generator.directory.component'));
        $component_file = sprintf('%s/%s', $component_dir, $file_name);
        //ジェネレイト
        $params['class_name'] = $class_name;
        $result = $this->_generate($component_file, $skeleton, $params);
        return array($result, $component_file);
    }
    
    
    /**
     * 「_」つながりで記述されたコンポーネント名を、実際のクラス名とファイル名に変換する。
     * @access     protected
     * @param      string  $component_name   コンポーネント名
     * @return     array   ファイル名など
     */
    protected function _makeNames($component_name)
    {
        $name = join('_', array_map('ucfirst', explode('_', $component_name)));
        $path = Samurai_Loader::getPathByClass($name);
        return array($name, $path);
    }
    
    
    
    
    
    /**
     * スケルトンの取得。
     * @access     public
     */
    public function getSkeleton(){
        $filename = $this->SKELETON;
        return parent::getSkeleton($filename);
    }
}
