<?
/**
 * ActiveGatewayCondition
 * 
 * ActiveGatewayにおいて、検索条件を保持するクラス。
 * ActiveGatewayのfindAll系のメソッドがこれを使用する。
 * 
 * @package    ActiveGateway
 * @subpackage ActiveGateway
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class ActiveGatewayCondition {
    public
        /** @var        mixed   SELECT */
        $select = NULL,
        /** @var        mixed   FROM */
        $from   = NULL,
        /** @var        mixed   WHERE */
        $where  = NULL,
        /** @var        mixed   ORDER */
        $order  = NULL,
        /** @var        mixed   GROUP */
        $group  = NULL,
        /** @var        int     LIMIT */
        $limit  = NULL,
        /** @var        int     OFFSET */
        $offset = NULL;
    public
        /** @var        boolean トータルローズを取得するかどうか */
        $total_rows    = true,
        /** @var        boolean 「active」フィールドを考慮するかどうか */
        $regard_active = true;
    
    
    /**
     * リミットをセット。
     * @access     public
     * @param      int     $limit   リミット
     */
    public function setLimit($limit)
    {
        $this->limit = (int)$limit;
    }
    
    
    /**
     * offset値の設定。
     * offsetというか、pageIDをセットする感じか？
     * 性質上、リミットをセットした後でないと意味を発揮しない。
     * pageID=falseの場合、裸の値がoffset値となる。
     * @access     public
     */
    public function setOffset($offset, $pageID=true)
    {
        $offset = (int)$offset;
        if($pageID){
            $offset = ($offset > 0) ? $offset - 1 : 0 ;
            $offset = (int)$this->limit * $offset;
        }
        if($offset < 0) $offset = 0;
        $this->offset = $offset;
    }
}
