<?
/**
 * ActiveGatewayRecords
 * 
 * ActiveGatewayにおいて、レコードの集合を管理するクラス。
 * ActiveGatewayの上位メソッド(findAll系)を使用すると、このクラスのインスタンスが返却される。
 * 
 * @package    ActiveGateway
 * @subpackage ActiveGateway
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class ActiveGatewayRecords
{
    private
        /** @var        array   レコードの集合 */
        $_records = array(),
        /** @var        int     レコードの参照index */
        $_index = 0,
        /** @var        int     総レコード数 */
        $_total_rows = 0;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * レコードを追加していく。
     * @access     public
     * @param      object  $Record   ActiveGatewayRecordインスタンス
     */
    public function addRecord($Record)
    {
        $this->_records[] = $Record;
    }
    
    
    /**
     * レコードを回していく。
     * @access     public
     * @return     object  レコードインスタンス
     */
    public function fetch()
    {
        if(isset($this->_records[$this->_index])){
            $Record = $this->_records[$this->_index];
            $this->_index++;
            return $Record;
        } else {
            $this->_index = 0;
            return false;
        }
    }
    
    
    /**
     * 最初のレコードを返却する。
     * @access     public
     * @return     object  レコードインスタンス
     */
    public function getFirstRecord()
    {
        if(!isset($this->_records[0])){
            return;
        } else {
            return $this->_records[0];
        }
    }
    
    
    /**
     * 無作為に1レコードを取り出す。
     * @access     public
     */
    public function getRandom()
    {
        if(!$this->_records) return;
        $key = array_rand($this->_records);
        return $this->_records[$key];
    }
    
    
    
    
    
    /**
     * 総レコード数を返却する。
     * @access     public
     * @return     int     総レコード数。
     */
    public function getTotalRows()
    {
        return $this->_total_rows;
    }
    /**
     * 総レコード数をセットする。
     * @access     public
     * @param      int     $total_rows   総レコード数
     */
    public function setTotalRows($total_rows)
    {
        if(!$total_rows) $total_rows = 0;
        $this->_total_rows = (int)$total_rows;
    }
    
    
    /**
     * 現在格納されているレコードのサイズを返却。
     * @access     public
     * @return     int     レコード群のサイズ
     */
    public function getSize()
    {
        return count($this->_records);
    }
    
    
    
    
    
    /**
     * 場所を判断。
     * それぞれの場所かどうか。
     * @access     public
     */
    public function isFirst()
    {
        return ($this->_index === 1);
    }
    public function isLast()
    {
        return ($this->_index === $this->getSize());
    }
    
    
    
    
    
    /**
     * 配列に変換する。
     * @access     public
     * @return     array   結果内容を配列に変換したもの
     */
    public function toArray()
    {
        $result = array();
        while($Record = $this->fetch()){
            $result[] = ActiveGatewayUtils::object2Array($Record);
        }
        return $result;
    }
}
