<?
/**
 * Smarty/plugins/modifier.convert2age.php
 * 
 * 日付を表す文字列から年齢を計算するプラグイン。
 * 日付として解釈できるかどうかは、strtotimeに依存する。
 * <code>
 *     // $date = '1983-09-07';
 *     {$date|date2age}
 * </code>
 * 
 * @package    Smarty
 * @subpackage modifier
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
function smarty_modifier_date2age($birth_date)
{
    //初期化
    list($now_year, $now_month, $now_day) = explode('-', date('Y-m-d'));
    list($birth_year, $birth_month, $birth_day) = explode('-', date('Y-m-d', strtotime($birth_date)));
    
    //計算
    $age = $now_year - $birth_year;
    if($now_month < $birth_month){
        $age--;
    }
    if($now_month == $birth_month && $now_day < $birth_day){
        $age--;
    }
    return $age;
}
