<?
/**
 * Smarty/plugins/modifier.quote.php
 * 
 * テキストの各行頭に引用符をくっつけるプラグイン。
 * <code>
 *     {$text|quote}
 *     {$text|quote:'-> '}
 * </code>
 * 
 * @package    Smarty
 * @subpackage modifier
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 * @param      string  $text     テキスト
 * @param      string  $quoter   引用符
 * @return     string  行頭に引用符を付加されたテキスト
 */
function smarty_modifier_quote($text, $quoter='> ')
{
    //改行を統一
    $text = str_replace("\r\n", "\n",   $text);
    $text = str_replace("\r",   "\n",   $text);
    $text = str_replace("\n",   "\r\n", $text);
    
    //引用符の付加
    $lines = explode("\r\n", $text);
    $text  = '';
    foreach($lines as $line){
        $text .= "{$quoter}{$line}\r\n";
    }
    return $text;
}
