;;;
;;; Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

(define default-context-rec-spec context-rec-spec)
(define-record 'default-context default-context-rec-spec)

(define default-push-back-mode
  (lambda (dc lst)
    (if (car lst)
	(begin
	  (im-pushback-mode-list dc (caar lst))
	  (default-push-back-mode dc (cdr lst))))))

(define default-init-handler
  (lambda (id im arg)
    (let ((dc (default-context-new id im)))
      ;;(im-clear-mode-list dc)
      ;;(default-push-back-mode dc im-list)
      ;;(im-update-mode-list dc)
      ;;(im-update-mode dc (- (length im-list) 1))
      dc)))

(define default-release-handler
  (lambda (dc)
    #f))

(define default-key-press-handler
  (lambda (dc key state)
    (im-commit-raw dc)))

(define default-key-release-handler
  (lambda (dc key state)
    (im-commit-raw dc)))

(define default-reset-handler
  (lambda (dc)
    #f))

(define default-mode-handler
  (lambda (dc mode)
    ;;(create-context (default-context-id dc)
    ;;		    #f
    ;;		    (car (nth mode im-list)))
    #f))

(define default-get-candidate-handler
  (lambda (dc idx)
    #f))

(define default-set-candidate-index-handler
  (lambda (dc idx)
    #f))

(define default-prop-handler
  (lambda (dc prop)
    #f))

(register-im
 'default
 "*"  ;; wildcard language. see i18n.scm
 "UTF-8"
 (N_ "Direct input mainly used for latin languages")
 #f
 default-init-handler
 default-release-handler
 default-mode-handler
 default-key-press-handler
 default-key-release-handler
 default-reset-handler
 default-get-candidate-handler
 default-set-candidate-index-handler
 default-prop-handler)
