#!/bin/sh
#
# alias-cid.sh - alias CID|TrueType font to CID-Keyed font
#
# Copyright (C) 2000,2001 Taiji Yamada <taiji@aihara.co.jp>
# Copyright (C) 2001 gs-cjk project. All rights reserved.
# This software is provided under the BSD license. For full details,
# please see COPYING file.
#
# Acknowledgment:
# It is a pleasure to thank Hideyuki Suzuki <hideyuki@sat.t.u-tokyo.ac.jp>,
# Jerry Zhang <wenlongzhang@redflag-linux.com>,
# Chih-Wei Huang <cwhuang@linux.org.tw>, Yasuhiro Take <take@debian.org>,
# James Su <suzhe@gnuchina.org>,
# suzuki toshiya <mpsuzuki@hiroshima-u.ac.jp> and
# Masatake YAMATO <masata-y@is.aist-nara.ac.jp> for many precious suggestions
# and stimulating discussions about this work.
#
#ResourceDir=.
ResourceDir=`echo "pssystemparams /GenericResourceDir get =" | gsnd -q - `
CIDFontDir=$ResourceDir/CIDFont
TTFontDir=/usr/local/share/fonts/truetype
# it requires gs6.51-cjk-*.tar.gz distributed at http://www.gyve.org/gs-cjk/
OpenTTCIDFont=.openttcidfont
cid_sh_path=$ResourceDir
do_cid_sh='no'	# cid.sh is not required since gs6.51-cjk-M2-R1
AliasListFile=./Alias.lst
ttctocid2_ps=ttctocid2.ps

case `basename $0` in
######################################################################
# Adobe CNS1
#
alias-ac1*.sh)
if [ ! -f $AliasListFile ]; then # you can write entries in single quotes
ALIASES='
'
else # otherwise, you can write entries in Alias.lst
ALIASES=` \
  tr -s '	' ' ' < $AliasListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]CNS1/\1 /p' \
`
fi
cid_sh=$cid_sh_path/ac1.sh
;;
######################################################################
# Adobe GB1
#
alias-ag1*.sh)
if [ ! -f $AliasListFile ]; then # you can write entries in single quotes
ALIASES='
'
else # otherwise, you can write entries in Alias.lst
ALIASES=` \
  tr -s '	' ' ' < $AliasListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]GB1/\1 /p' \
`
fi
cid_sh=$cid_sh_path/ag1.sh
;;
######################################################################
# Adobe Japan1
#
alias-aj1*.sh)
if [ ! -f $AliasListFile ]; then # you can write entries in single quotes
ALIASES='
'
else # otherwise, you can write entries in Alias.lst
ALIASES=` \
  tr -s '	' ' ' < $AliasListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Japan1/\1 /p' \
`
fi
cid_sh=$cid_sh_path/aj1.sh
;;
######################################################################
# Adobe Japan2
#
alias-aj2*.sh)
if [ ! -f $AliasListFile ]; then # you can write entries in single quotes
ALIASES='
'
else # otherwise, you can write entries in Alias.lst
ALIASES=` \
  tr -s '	' ' ' < $AliasListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Japan2/\1 /p' \
`
fi
cid_sh=$cid_sh_path/aj2.sh
;;
######################################################################
# Adobe Korea1
#
alias-ak1*.sh)
if [ ! -f $AliasListFile ]; then # you can write entries in single quotes
ALIASES='
'
else # otherwise, you can write entries in Alias.lst
ALIASES=` \
  tr -s '	' ' ' < $AliasListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Korea1/\1 /p' \
`
fi
cid_sh=$cid_sh_path/ak1.sh
;;
#
# print usage
#
*)
if [ "$1" != 'uninstall' ]; then
  cat <<EOF
do not execute $0, directly! in the case except for uninstall
usage: alias-(ac1|ag1|aj1|aj2|ak1).sh 'install|uninstall' [Alias=Font...]
EOF
  exit 1
fi
;;
esac

case $1 in
'install')
  if [ "$2" != '' ]; then
    shift
    ALIASES=$*
  fi
  for alias in $ALIASES; do
    FNN=`echo $alias|sed -n -e 's/^\(.*\)=\(.*\)$/\1/p'`
    fnn=`echo $alias|sed -n -e 's/^\(.*\)=\(.*\)$/\2/p'`
    [ "$FNN" = '' -o "$fnn" = '' ] && echo "error: $alias" && exit 1
    dot_openttcidfont=$OpenTTCIDFont
    do_makebold='no'; default_makebold='.03'
    do_makefont='no'; default_makefont='[1 0 .3 1 0 0]'
    do_ttctocid2='no'; ttctocid2_ps_flags=''
    case $FNN in
    *:=)
      do_ttctocid2='yes'
      #ttctocid2_ps_flags='-sTTCHANDLER=.opencjkvttcidfont -dVERBCIDMAP'
      ttctocid2_ps_flags='-sTTCHANDLER=.opencjkvttcidfont'
      FNN=`echo $FNN|sed -e 's/:=$//'`
      ;;
    *:)
      do_ttctocid2='yes'
      #ttctocid2_ps_flags='-sTTCHANDLER=.openttcidfont -dVERBCIDMAP'
      ttctocid2_ps_flags='-sTTCHANDLER=.openttcidfont'
      FNN=`echo $FNN|sed -e 's/:$//'`
      ;;
    *=)
      if [ $OpenTTCIDFont = '.openttcidfont' ]; then
        dot_openttcidfont=.opencjkvttcidfont
      else
        dot_openttcidfont=.openttcidfont
      fi
      do_ttctocid2='no'
      FNN=`echo $FNN|sed -e 's/=$//'`
      ;;
    esac
    TTE=''
    case $FNN in
    *-Adobe-*[0-9])
      #TTE=' /'`echo $FNN|sed -n -e 's/^.*-\(Adobe-.*[0-9]\)$/\1/p'`'-Unicode'
      TTE=' /'`echo $FNN|sed -n -e 's/^.*-\(Adobe-.*[0-9]\)$/\1/p'`
      ;;
    #*,Adobe-*[0-9]-*)
    *,Adobe-*[0-9]*)
      #TTE=' /'`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9]-.*\)$/\2/p'`
      #FNN=`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9]-.*\)$/\1/p'`
      TTE=' /'`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9].*\)$/\2/p'`
      FNN=`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9].*\)$/\1/p'`
      ;;
    esac
    case $fnn in
    *.ttc,[0-9]|*.TTC,[0-9])
      TTF=`echo $fnn|sed -n -e 's/^\(.*\),\([0-9]\)$/\1/p'`
      TTI=`echo $fnn|sed -n -e 's/^\(.*\),\([0-9]\)$/\2/p'`
      if [ ! -f $TTFontDir/$TTF ]; then
        echo "$TTF not found in $TTFontDir"; continue
      fi
      if [ "$do_ttctocid2" = 'no' ]; then
        [ ! -f $CIDFontDir/$FNN ] && cat <<EOF > $CIDFontDir/$FNN && echo "+$FNN=$TTF"
%!PS-Adobe-3.0 Resource-CIDFont
%%BeginResource: CIDFont ($FNN)
/$FNN
($TTFontDir/$TTF) $TTI$TTE $dot_openttcidfont
dup length dict begin {def} forall currentdict end
/CIDFont defineresource pop
%%EndResource
%%EOF
EOF
      else
        if [ "$TTI" != "" ]; then
          TTI="-sINDEX=$TTI"
        fi
        if [ "$TTE" != "" ]; then
          TTE=`echo $TTE|sed -n -e 's/^\/\(.*\)$/-sMAPNAME=\1/p'`
        fi
        [ ! -f $CIDFontDir/$FNN ] && gsnd -q -sINPUT=$TTFontDir/$TTF -sOUTPUTDIR=$CIDFontDir -sRENAME=$FNN -dNONULLINFO $TTI $TTE $ttctocid2_ps_flags $ttctocid2_ps && echo "+$FNN:=$TTF"
      fi
      ;;
    *.tt[fc]|*.TT[FC])
      TTF=$fnn
      if [ ! -f $TTFontDir/$TTF ]; then
        echo "$TTF not found in $TTFontDir"; continue
      fi
      if [ "$do_ttctocid2" = 'no' ]; then
        [ ! -f $CIDFontDir/$FNN ] && cat <<EOF > $CIDFontDir/$FNN && echo "+$FNN=$TTF"
%!PS-Adobe-3.0 Resource-CIDFont
%%BeginResource: CIDFont ($FNN)
/$FNN
($TTFontDir/$TTF)$TTE $dot_openttcidfont
dup length dict begin {def} forall currentdict end
/CIDFont defineresource pop
%%EndResource
%%EOF
EOF
      else
        if [ "$TTE" != "" ]; then
          TTE=`echo $TTE|sed -n -e 's/^\/\(.*\)$/-sMAPNAME=\1/p'`
        fi
        [ ! -f $CIDFontDir/$FNN ] && gsnd -q -sINPUT=$TTFontDir/$TTF -sOUTPUTDIR=$CIDFontDir -sRENAME=$FNN -dNONULLINFO $TTE $ttctocid2_ps_flags $ttctocid2_ps && echo "+$FNN:=$TTF"
      fi
      ;;
    *)
      case $fnn in
      *,*)
        fnm=`echo $fnn|sed -n -e 's/\([^,]*\),\(.*\)/\2/p'|sed -e 's/,/ /g'`
        fnn=`echo $fnn|sed -n -e 's/\([^,]*\),\(.*\)/\1/p'`
        makefont=`echo $fnm|sed -n -e 's/.*\(\[.*\]\).*/\1/p'`
        [ "$makefont" != "" ] && do_makefont='yes' && fnm=`echo $fnm|sed -n -e 's/\([^][]*\)\[.*\]\([^][]*\)/\1\2/p'`
        for m in $fnm; do
          case $m in
          Bold)
            do_makebold='yes'; makebold="$default_makebold"
            ;;
          Italic)
            do_makefont='yes'; makefont="$default_makefont"
            ;;
          BoldItalic)	
            do_makebold='yes'; makebold="$default_makebold"
            do_makefont='yes'; makefont="$default_makefont"
            ;;
          *)
            do_makebold='yes'; makebold="$m"
            ;;
          esac
        done
        ;;
      esac
      if [ ! -f $CIDFontDir/$fnn ]; then
        echo "$fnn not found in $CIDFontDir"; continue
      fi
      if [ ! -f $CIDFontDir/$FNN ]; then
        cat <<EOF > $CIDFontDir/$FNN && echo -n "+$FNN=$fnn"
%!PS-Adobe-3.0 Resource-CIDFont
%%BeginResource: CIDFont ($FNN)
/$FNN
/$fnn /CIDFont findresource
EOF
        [ $do_makefont = 'no' -a $do_makebold = 'no' ] &&
        cat <<EOF >>$CIDFontDir/$FNN && echo -n ""
dup length dict begin {def} forall currentdict end
EOF
        [ $do_makebold = 'yes' ] &&
        cat <<EOF >>$CIDFontDir/$FNN && echo -n ",Bold($makebold)"
16 dict begin
  /basecidfont exch def
  /basefont-H /.basefont-H /Identity-H [ basecidfont ] composefont def
  /basefont-V /.basefont-V /Identity-V [ basecidfont ] composefont def
  /CIDFontName dup basecidfont exch get def
  /CIDFontType 1 def
  /CIDSystemInfo dup basecidfont exch get def
  /FontInfo dup basecidfont exch get def
  /FontMatrix [ 1 0 0 1 0 0 ] def
  /FontBBox [
    basecidfont /FontBBox get cvx exec
    4 2 roll basecidfont /FontMatrix get transform
    4 2 roll basecidfont /FontMatrix get transform
  ] def
  /cid 2 string def
  /BuildGlyph {
    gsave
    exch begin
      dup 256 idiv cid exch 0 exch put
      256 mod cid exch 1 exch put
      rootfont /WMode known { rootfont /WMode get 1 eq } { false } ifelse
      { basefont-V } { basefont-H } ifelse setfont
      $makebold setlinewidth 1 setlinejoin
      newpath
      0 0 moveto cid false charpath stroke
      0 0 moveto cid show
      currentpoint setcharwidth
    end
    grestore
  } bind def
  currentdict
end
EOF
        [ $do_makebold = 'trial2' ] &&
        cat <<EOF >>$CIDFontDir/$FNN && echo -n ",Bold($makebold)"
16 dict begin
  /basecidfont exch def
  /basefont-H /.basefont-H /Identity-H [ basecidfont ] composefont def
  /basefont-V /.basefont-V /Identity-V [ basecidfont ] composefont def
  /CIDFontName dup basecidfont exch get def
  /CIDFontType 1 def
  /CIDSystemInfo dup basecidfont exch get def
  /FontInfo dup basecidfont exch get def
  /FontMatrix [ 1 0 0 1 0 0 ] def
  /FontBBox [
    basecidfont /FontBBox get cvx exec
    4 2 roll basecidfont /FontMatrix get transform
    4 2 roll basecidfont /FontMatrix get transform
  ] def
  /cid 2 string def
  /BuildGlyph {
    gsave
    exch begin
      dup 256 idiv cid exch 0 exch put
      256 mod cid exch 1 exch put
      rootfont /WMode known { rootfont /WMode get 1 eq } { false } ifelse
      { basefont-V } { basefont-H } ifelse setfont
      newpath
      0 0 moveto cid false charpath
      $makebold setlinewidth 1 setlinejoin strokepath
      0 0 moveto cid true charpath
      0 0 moveto cid true charpath
      currentpoint setcharwidth
      fill
    end
    grestore
  } bind def
  currentdict
end
EOF
        [ $do_makebold = 'trial1' ] &&
        cat <<EOF >>$CIDFontDir/$FNN && echo -n ",Bold($makebold)"
16 dict begin
  /basecidfont exch def
  /basecidfont-outline basecidfont dup length 2 add dict copy begin
    /StrokeWidth $makebold 0 basecidfont /FontMatrix get idtransform
    dup mul exch dup mul add sqrt def
    /PaintType 2 def
  currentdict end /.basecidfont-outline exch /CIDFont defineresource def
  /basefont-H /.basefont-H /Identity-H [ basecidfont ] composefont def
  /basefont-V /.basefont-V /Identity-V [ basecidfont ] composefont def
  /basefont-outline-H
    /.basefont-H /Identity-H [ basecidfont-outline ] composefont def
  /basefont-outline-V
    /.basefont-V /Identity-V [ basecidfont-outline ] composefont def
  /CIDFontName dup basecidfont exch get def
  /CIDFontType 1 def
  /CIDSystemInfo dup basecidfont exch get def
  /FontInfo dup basecidfont exch get def
  /FontMatrix [ 1 0 0 1 0 0 ] def
  /FontBBox [
    basecidfont /FontBBox get cvx exec
    4 2 roll basecidfont /FontMatrix get transform
    4 2 roll basecidfont /FontMatrix get transform
  ] def
  /cid 2 string def
  /BuildGlyph {
    gsave
    exch begin
      dup 256 idiv cid exch 0 exch put
      256 mod cid exch 1 exch put
      rootfont /WMode known { rootfont /WMode get 1 eq } { false } ifelse
      { basefont-outline-V basefont-V }
      { basefont-outline-H basefont-H } ifelse
      setfont 0 0 moveto cid show
      currentpoint setcharwidth
      1 setlinejoin
      setfont 0 0 moveto cid show
    end
    grestore
  } bind def
  currentdict
end
EOF
        [ $do_makefont = 'yes' ] &&
        cat <<EOF >>$CIDFontDir/$FNN && echo -n ",makefont($makefont)"
dup length dict begin { 1 index /FontMatrix eq { $makefont matrix concatmatrix def } { def } ifelse } forall currentdict end
EOF
        cat <<EOF >>$CIDFontDir/$FNN && echo ""
/CIDFont defineresource pop
%%EndResource
%%EOF
EOF
      fi
      ;;
    esac
    if [ "$do_cid_sh" = 'yes' ]; then
      [ "$cid_sh" != '' ] && (cd $ResourceDir; $cid_sh install $FNN)
    fi
  done
  ;;
'uninstall')
  if [ "$2" != '' ]; then
    shift
    ALIASES=$*
  fi
  for alias in $ALIASES; do
    FNN=`echo $alias|sed -n -e 's/^\(.*\)=\(.*\)$/\1/p'`
    fnn=`echo $alias|sed -n -e 's/^\(.*\)=\(.*\)$/\2/p'`
    case $FNN in
    *:=)
      FNN=`echo $FNN|sed -e 's/:=$//'`
      ;;
    *:)
      FNN=`echo $FNN|sed -e 's/:$//'`
      ;;
    *=)
      FNN=`echo $FNN|sed -e 's/=$//'`
      ;;
    esac
    case $FNN in
    #*,Adobe-*[0-9]-*)
    *,Adobe-*[0-9]*)
      #FNN=`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9]-.*\)$/\1/p'`
      FNN=`echo $FNN|sed -n -e 's/^\(.*\),\(Adobe-.*[0-9].*\)$/\1/p'`
      ;;
    '')
      FNN=$alias
      ;;
    esac
#    if [ "$do_cid_sh" = 'yes' ]; then
      [ "$cid_sh" != '' ] && (cd $ResourceDir; $cid_sh uninstall $FNN)
      [ "$cid_sh" = '' ] && (cd $ResourceDir; $cid_sh_path/cid.sh uninstall $FNN)
#    fi
    [ -f $CIDFontDir/$FNN ] && rm -f $CIDFontDir/$FNN && echo "-$FNN"
  done
  ;;
*)
  cat <<EOF
usage: $0 'install|uninstall' [Arias=Font...]
please edit the lines ALIASES=<alias>=<name>... of me, before use without args.
EOF
  exit 1
  ;;
esac
exit 0
