/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.UnicodeStringParser;
import writer2latex.latex.style.UnicodeTable;
import writer2latex.latex.style.UnicodeTableHandler;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;

public class I18n {
    public static final int ASCII = 0;
    public static final int LATIN1 = 1;
    public static final int LATIN2 = 2;
    public static final int ISO_8859_7 = 3;
    public static final int CP1250 = 4;
    public static final int CP1251 = 5;
    public static final int KOI8_R = 6;
    public static final int UTF8 = 7;
    public static final int OT1_ENC = 1;
    public static final int T1_ENC = 2;
    public static final int T2A_ENC = 4;
    public static final int T3_ENC = 8;
    public static final int LGR_ENC = 16;
    public static final int ANY_ENC = 31;
    private Hashtable tableSet;
    private UnicodeTable table;
    private Stack tableStack;
    private UnicodeStringParser ucparser;
    private String sDefaultLang = null;
    private int nDefaultFontenc = 0;
    private boolean bAlwaysUseDefaultLang = false;
    private boolean bT2A = false;
    private boolean bGreek = false;
    private boolean bPolytonicGreek = false;
    private boolean bGreekMath;
    private String sMajorityLanguage = null;
    private Config config;
    private WriterStyleCollection wsc;

    public static final int readInputenc(String string) {
        if ("ascii".equals(string)) {
            return 0;
        }
        if ("latin1".equals(string)) {
            return 1;
        }
        if ("latin2".equals(string)) {
            return 2;
        }
        if ("iso-8859-7".equals(string)) {
            return 3;
        }
        if ("cp1250".equals(string)) {
            return 4;
        }
        if ("cp1251".equals(string)) {
            return 5;
        }
        if ("koi8-r".equals(string)) {
            return 6;
        }
        if ("utf8".equals(string)) {
            return 7;
        }
        return 0;
    }

    public static final String writeInputenc(int n) {
        switch (n) {
            case 0: {
                return "ascii";
            }
            case 1: {
                return "latin1";
            }
            case 2: {
                return "latin2";
            }
            case 3: {
                return "iso-8859-7";
            }
            case 4: {
                return "cp1250";
            }
            case 5: {
                return "cp1251";
            }
            case 6: {
                return "koi8-r";
            }
            case 7: {
                return "utf8";
            }
        }
        return "???";
    }

    public static final String writeJavaEncoding(int n) {
        switch (n) {
            case 0: {
                return "ASCII";
            }
            case 1: {
                return "ISO8859_1";
            }
            case 2: {
                return "ISO8859_2";
            }
            case 3: {
                return "ISO8859_7";
            }
            case 4: {
                return "Cp1250";
            }
            case 5: {
                return "Cp1251";
            }
            case 6: {
                return "KOI8_R";
            }
            case 7: {
                return "UTF-8";
            }
        }
        return "???";
    }

    public static final int readFontencs(String string) {
        if ("ANY".equals(string = string.toUpperCase())) {
            return 31;
        }
        int n = 0;
        int n2 = string.indexOf("OT1");
        int n3 = string.indexOf("T1");
        int n4 = string.indexOf("T2A");
        int n5 = string.indexOf("T3");
        int n6 = string.indexOf("LGR");
        if (n2 >= 0) {
            ++n;
        }
        if (n3 == 0 || n3 > 0 && n3 != n2 + 1) {
            n += 2;
        }
        if (n4 >= 0) {
            n += 4;
        }
        if (n5 >= 0) {
            n += 8;
        }
        if (n6 >= 0) {
            n += 16;
        }
        return n;
    }

    public static final String writeFontenc(int n) {
        switch (n) {
            case 1: {
                return "OT1";
            }
            case 2: {
                return "T1";
            }
            case 4: {
                return "T2A";
            }
            case 8: {
                return "T3";
            }
            case 16: {
                return "LGR";
            }
        }
        return null;
    }

    public static final boolean supportsFontenc(int n, int n2) {
        return (n & n2) != 0;
    }

    public static final int getFontenc(int n) {
        if (I18n.supportsFontenc(n, 2)) {
            return 2;
        }
        if (I18n.supportsFontenc(n, 4)) {
            return 4;
        }
        if (I18n.supportsFontenc(n, 8)) {
            return 8;
        }
        if (I18n.supportsFontenc(n, 16)) {
            return 16;
        }
        return 0;
    }

    public static final int getFontenc(String string) {
        if ("el".equals(string)) {
            return 16;
        }
        if ("ru".equals(string)) {
            return 4;
        }
        if ("uk".equals(string)) {
            return 4;
        }
        if ("bg".equals(string)) {
            return 4;
        }
        if ("sr".equals(string)) {
            return 4;
        }
        return 2;
    }

    public static final String getFontencCs(int n) {
        switch (n) {
            case 2: {
                return "\\textlatin";
            }
            case 4: {
                return "\\textcyrillic";
            }
            case 8: {
                return "\\textipa";
            }
            case 16: {
                return "\\textgreek";
            }
        }
        return null;
    }

    public static final String getBabelLanguage(String string) {
        if ("en".equals(string)) {
            return "english";
        }
        if ("bg".equals(string)) {
            return "bulgarian";
        }
        if ("cs".equals(string)) {
            return "czech";
        }
        if ("da".equals(string)) {
            return "danish";
        }
        if ("de".equals(string)) {
            return "ngerman";
        }
        if ("el".equals(string)) {
            return "greek";
        }
        if ("es".equals(string)) {
            return "spanish";
        }
        if ("fi".equals(string)) {
            return "finnish";
        }
        if ("fr".equals(string)) {
            return "french";
        }
        if ("ga".equals(string)) {
            return "irish";
        }
        if ("hr".equals(string)) {
            return "croatian";
        }
        if ("hu".equals(string)) {
            return "magyar";
        }
        if ("is".equals(string)) {
            return "icelandic";
        }
        if ("it".equals(string)) {
            return "italian";
        }
        if ("nl".equals(string)) {
            return "dutch";
        }
        if ("no".equals(string)) {
            return "norsk";
        }
        if ("pl".equals(string)) {
            return "polish";
        }
        if ("pt".equals(string)) {
            return "portuges";
        }
        if ("ro".equals(string)) {
            return "romanian";
        }
        if ("ru".equals(string)) {
            return "russian";
        }
        if ("sk".equals(string)) {
            return "slovak";
        }
        if ("sl".equals(string)) {
            return "slovene";
        }
        if ("sr".equals(string)) {
            return "serbian";
        }
        if ("sv".equals(string)) {
            return "swedish";
        }
        if ("uk".equals(string)) {
            return "ukrainian";
        }
        return null;
    }

    public I18n(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        this.wsc = writerStyleCollection;
        this.config = config;
        String string = "ascii";
        if (config.getInputencoding() != 0) {
            string = string + "|" + I18n.writeInputenc(config.getInputencoding());
        }
        if (config.useWasysym()) {
            string = string + "|wasysym";
        }
        if (config.useBbding()) {
            string = string + "|bbding";
        }
        if (config.useIfsym()) {
            string = string + "|ifsym";
        }
        if (config.usePifont()) {
            string = string + "|dingbats";
        }
        if (config.useEurosym()) {
            string = string + "|eurosym";
        }
        if (config.useTipa()) {
            string = string + "tipa";
        }
        this.readSymbols(string);
        this.bGreekMath = config.greekMath();
        this.bAlwaysUseDefaultLang = !config.multilingual();
        this.ucparser = new UnicodeStringParser();
    }

    public I18n(String string) {
        this.readSymbols(string);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.config.getInputencoding() == 7) {
            laTeXDocumentPortion.append("\\usepackage[dirty,autogenerated]{ucs}").nl();
        }
        laTeXDocumentPortion.append("\\usepackage[").append(I18n.writeInputenc(this.config.getInputencoding())).append("]{inputenc}").nl();
        CSVList cSVList = new CSVList(',');
        if (this.bT2A) {
            cSVList.addValue("T2A");
        }
        if (this.bGreek) {
            cSVList.addValue("LGR");
        }
        if (this.config.useTipa()) {
            cSVList.addValue("T3");
        }
        cSVList.addValue("T1");
        laTeXDocumentPortion.append("\\usepackage[").append(cSVList.toString()).append("]{fontenc}").nl();
        this.convertLanguageUsage(laTeXDocumentPortion);
        if (this.config.useTipa()) {
            laTeXDocumentPortion.append("\\usepackage[noenc]{tipa}").nl().append("\\usepackage{tipx}").nl();
        }
        if (this.config.useBbding()) {
            laTeXDocumentPortion.append("\\usepackage{bbding}").nl().append("\\let\\bbCross\\Cross\\let\\Cross\\undefined").nl().append("\\let\\bbSquare\\Square\\let\\Square\\undefined").nl().append("\\let\\bbTrianbleUp\\TriangleUp\\let\\TriangleUp\\undefined").nl().append("\\let\\bbTrianlgeDown\\TriangleDown\\let\\TriangleDown\\undefined").nl();
        }
        if (this.config.useIfsym()) {
            laTeXDocumentPortion.append("\\usepackage[geometry,weather,misc,clock]{ifsym}").nl();
        }
        if (this.config.usePifont()) {
            laTeXDocumentPortion.append("\\usepackage{pifont}").nl();
        }
        if (this.config.useEurosym()) {
            laTeXDocumentPortion.append("\\usepackage{eurosym}").nl();
        }
        if (this.config.useWasysym()) {
            laTeXDocumentPortion.append("\\usepackage{amsmath,wasysym,amssymb,amsfonts,textcomp}").nl();
        } else {
            laTeXDocumentPortion.append("\\usepackage{amsmath,amssymb,amsfonts,textcomp}").nl();
        }
    }

    public void setDefaultLanguage(String string) {
        this.sDefaultLang = string;
        this.nDefaultFontenc = I18n.getFontenc(string);
    }

    public void applyLanguage(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter) {
        if (this.bAlwaysUseDefaultLang) {
            return;
        }
        if (styleWithProperties == null) {
            return;
        }
        String string = I18n.getBabelLanguage(styleWithProperties.getProperty("fo:language", bl2));
        if (string == null) {
            return;
        }
        if (bl) {
            beforeAfter.add("\\selectlanguage{" + string + "}", "");
        } else {
            beforeAfter.add("\\foreignlanguage{" + string + "}{", "}");
        }
    }

    public String getMajorityLanguage() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String string = null;
        StyleWithProperties styleWithProperties = this.wsc.getDefaultParStyle();
        if (styleWithProperties != null) {
            string = styleWithProperties.getProperty("fo:language");
        }
        Enumeration enumeration = this.wsc.getParStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            styleWithProperties = (StyleWithProperties)enumeration.nextElement();
            String string2 = styleWithProperties.getProperty("fo:language");
            if (string2 == null) {
                string2 = string;
            }
            if (string2 == null) continue;
            int n = 1;
            if (hashtable.containsKey(string2)) {
                n = (Integer)hashtable.get(string2) + 1;
            }
            hashtable.put(string2, new Integer(n));
        }
        int n = 0;
        String string3 = null;
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(string4);
            if (n2 <= n) continue;
            n = n2;
            string3 = string4;
        }
        this.sMajorityLanguage = string3;
        return string3;
    }

    private void convertLanguageUsage(LaTeXDocumentPortion laTeXDocumentPortion) {
        String string;
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        if (this.config.multilingual()) {
            object2 = this.wsc.getTextStyles().getStylesEnumeration();
            while (object2.hasMoreElements()) {
                object = (StyleWithProperties)object2.nextElement();
                string = I18n.getBabelLanguage(((StyleWithProperties)object).getProperty("fo:language"));
                if (string == null || vector.contains(string)) continue;
                vector.add(string);
            }
            object2 = this.wsc.getParStyles().getStylesEnumeration();
            while (object2.hasMoreElements()) {
                object = (StyleWithProperties)object2.nextElement();
                string = I18n.getBabelLanguage(((StyleWithProperties)object).getProperty("fo:language"));
                if (string == null || vector.contains(string)) continue;
                vector.add(string);
            }
            object = this.wsc.getDefaultParStyle();
            if (object != null) {
                string2 = I18n.getBabelLanguage(((StyleWithProperties)object).getProperty("fo:language"));
            }
        } else {
            string2 = I18n.getBabelLanguage(this.sMajorityLanguage == null ? this.getMajorityLanguage() : this.sMajorityLanguage);
        }
        if (this.greek() && !vector.contains("greek")) {
            vector.add("greek");
        }
        if (this.cyrillic() && !vector.contains("ukrainian") && !vector.contains("ukrainian") && !vector.contains("ukrainian")) {
            vector.add("russian");
        }
        object2 = new CSVList(",");
        object = vector.elements();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (string.equals(string2)) continue;
            if ("greek".equals(string) && this.polytonicGreek()) {
                string = "polutonikogreek";
            }
            ((CSVList)object2).addValue(string);
        }
        if (string2 != null) {
            if ("greek".equals(string2) && this.polytonicGreek()) {
                ((CSVList)object2).addValue("polutonikogreek");
            } else {
                ((CSVList)object2).addValue(string2);
            }
        }
        if (!((CSVList)object2).isEmpty()) {
            laTeXDocumentPortion.append("\\usepackage[").append(((CSVList)object2).toString()).append("]{babel}").nl();
        }
    }

    private void readSymbols(String string) {
        this.tableSet = new Hashtable();
        UnicodeTableHandler unicodeTableHandler = new UnicodeTableHandler(this.tableSet, string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        InputStream inputStream = this.getClass().getResourceAsStream("symbols.xml");
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)unicodeTableHandler);
        }
        catch (Throwable throwable) {
            System.out.println("Oops - Unable to read symbols.xml");
            throwable.printStackTrace();
        }
        this.tableStack = new Stack();
        this.tableStack.push((UnicodeTable)this.tableSet.get("root"));
        this.table = (UnicodeTable)this.tableSet.get("root");
    }

    public boolean cyrillic() {
        return this.bT2A;
    }

    public boolean greek() {
        return this.bGreek;
    }

    public boolean polytonicGreek() {
        return this.bPolytonicGreek;
    }

    private boolean greekMath(char c, int n) {
        return this.bGreekMath && n != 16 && this.table.getFontencs(c) == 16;
    }

    private void setFlags(char c, int n) {
        if (c >= '\u1f00' && c <= '\u1fff') {
            this.bPolytonicGreek = true;
        }
        if (n == 16) {
            this.bGreek = true;
        }
        if (n == 4) {
            this.bT2A = true;
        }
    }

    private String notFound(char c, int n) {
        String string = "[" + Integer.toHexString(c).toUpperCase() + "?]";
        if (n == 2) {
            return string;
        }
        return "\\textlatin{" + string + "}";
    }

    private String convertMathChar(char c, int n) {
        if (this.table.hasMathChar(c)) {
            return this.table.getMathChar(c);
        }
        if (this.table.hasTextChar(c)) {
            int n2 = this.table.getFontencs(c);
            if (I18n.supportsFontenc(n2, n)) {
                this.setFlags(c, n);
                if (this.table.getCharType(c) == 1) {
                    return "\\text{" + this.table.getTextChar(c) + "{}}";
                }
                return "\\text{" + this.table.getTextChar(c) + "}";
            }
            int n3 = I18n.getFontenc(n2);
            this.setFlags(c, n3);
            if (this.table.getCharType(c) == 1) {
                return "\\text{" + I18n.getFontencCs(n3) + "{" + this.table.getTextChar(c) + "{}}}";
            }
            return "\\text{" + I18n.getFontencCs(n3) + "{" + this.table.getTextChar(c) + "}}";
        }
        return "\\text{" + this.notFound(c, n) + "}";
    }

    public String convert(char c, boolean bl, String string) {
        int n;
        int n2 = n = this.bAlwaysUseDefaultLang ? this.nDefaultFontenc : I18n.getFontenc(string);
        if (bl) {
            return this.convertMathChar(c, n);
        }
        if (this.greekMath(c, n) || this.table.hasMathChar(c) && !this.table.hasTextChar(c)) {
            return "$" + this.convertMathChar(c, n) + "$";
        }
        if (this.table.hasTextChar(c)) {
            int n3 = this.table.getFontencs(c);
            if (I18n.supportsFontenc(n3, n)) {
                this.setFlags(c, n);
                if (this.table.getCharType(c) == 1) {
                    return this.table.getTextChar(c) + "{}";
                }
                return this.table.getTextChar(c);
            }
            int n4 = I18n.getFontenc(n3);
            this.setFlags(c, n4);
            if (this.table.getCharType(c) == 1) {
                return I18n.getFontencCs(n4) + "{" + this.table.getTextChar(c) + "{}}";
            }
            return I18n.getFontencCs(n4) + "{" + this.table.getTextChar(c) + "}";
        }
        return this.notFound(c, n);
    }

    public String convert(String string, boolean bl, String string2) {
        int n;
        int n2 = n = this.bAlwaysUseDefaultLang ? this.nDefaultFontenc : I18n.getFontenc(string2);
        this.ucparser.reset(this.table, string);
        StringBuffer stringBuffer = new StringBuffer();
        while (this.ucparser.next()) {
            char c = this.ucparser.getChar();
            if (bl) {
                stringBuffer.append(this.convertMathChar(c, n));
                continue;
            }
            if (this.greekMath(c, n) || this.table.hasMathChar(c) && !this.table.hasTextChar(c)) {
                stringBuffer.append("$").append(this.convertMathChar(c, n)).append("$");
                continue;
            }
            if (this.table.hasTextChar(c)) {
                int n3;
                int n4 = this.table.getFontencs(c);
                if (I18n.supportsFontenc(n4, n2)) {
                    this.setFlags(c, n2);
                    if (this.ucparser.hasCombiningChar()) {
                        n3 = this.ucparser.getCombiningChar();
                        if (I18n.supportsFontenc(this.table.getFontencs((char)n3), n2)) {
                            stringBuffer.append(this.table.getTextChar((char)n3)).append("{").append(this.table.getTextChar(c)).append("}");
                            continue;
                        }
                        stringBuffer.append(this.table.getTextChar(c));
                        continue;
                    }
                    stringBuffer.append(this.table.getTextChar(c));
                    continue;
                }
                n3 = I18n.getFontenc(n4);
                this.setFlags(c, n3);
                if (n2 != n) {
                    stringBuffer.append("}");
                }
                if (n3 != n) {
                    stringBuffer.append(I18n.getFontencCs(n3)).append("{");
                }
                if (this.ucparser.hasCombiningChar()) {
                    char c2 = this.ucparser.getCombiningChar();
                    if (I18n.supportsFontenc(this.table.getFontencs(c2), n2)) {
                        stringBuffer.append(this.table.getTextChar(c2)).append("{").append(this.table.getTextChar(c)).append("}");
                    } else {
                        stringBuffer.append(this.table.getTextChar(c));
                    }
                } else {
                    stringBuffer.append(this.table.getTextChar(c));
                }
                n2 = n3;
                continue;
            }
            stringBuffer.append(this.notFound(c, n2));
        }
        if (n2 != n) {
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public void pushSpecialTable(String string) {
        if (string != null) {
            this.table = (UnicodeTable)this.tableSet.get(string);
            if (this.table == null) {
                this.table = (UnicodeTable)this.tableSet.get("root");
            }
        }
        this.tableStack.push(this.table);
    }

    public void popSpecialTable() {
        this.tableStack.pop();
        this.table = (UnicodeTable)this.tableStack.peek();
    }

    public int getCharCount() {
        return this.table.getCharCount();
    }
}

