/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XStandaloneDocumentInfo;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XMacroExpander;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class FileAccess {
    public XSimpleFileAccess2 fileAccess;
    public XFileIdentifierConverter filenameConverter;

    public static void addOfficePath(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        XSimpleFileAccess xSimpleFileAccess = null;
        String string3 = FileAccess.getOfficePath(xMultiServiceFactory, string, xSimpleFileAccess);
        String[] stringArray = JavaTools.ArrayoutofString(string3, ";");
        boolean bl = false;
        int n = stringArray.length - 1;
        String string4 = JavaTools.replaceSubString(string2, "", "/");
        for (int i = 0; i <= n; ++i) {
            String string5 = JavaTools.convertfromURLNotation(stringArray[i]);
            String string6 = JavaTools.replaceSubString(string5, "", "/");
            if (!string6.equals(string4)) continue;
            return;
        }
        string3 = string3 + ";" + string2;
    }

    public static String deleteLastSlashfromUrl(String string) {
        if (string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getOfficePath(XMultiServiceFactory xMultiServiceFactory, String string, XSimpleFileAccess xSimpleFileAccess) {
        try {
            String string2 = "";
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            string2 = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xInterface, string));
            string2 = FileAccess.deleteLastSlashfromUrl(string2);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return "";
        }
    }

    public static String getOfficePath(XMultiServiceFactory xMultiServiceFactory, String string, String string2, String string3) throws NoValidPathException {
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        try {
            int n;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            String string6 = "";
            String[] stringArray = null;
            XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface2);
            string5 = (String)xPropertySet.getPropertyValue(string + "_writable");
            String[] stringArray2 = (String[])xPropertySet.getPropertyValue(string + "_internal");
            String[] stringArray3 = (String[])xPropertySet.getPropertyValue(string + "_user");
            int n2 = stringArray3.length + stringArray2.length + 1;
            stringArray = new String[n2];
            int n3 = 0;
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n3] = stringArray2[n];
                ++n3;
            }
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n3] = stringArray3[n];
                ++n3;
            }
            stringArray[n3] = string5;
            string6 = string5;
            if (string2.equalsIgnoreCase("user")) {
                string4 = string6;
                bl = true;
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    String string7 = stringArray[n] + string3;
                    if (!xSimpleFileAccess.exists(string7)) continue;
                    string4 = stringArray[n];
                    bl = true;
                    break;
                }
            }
            string4 = FileAccess.deleteLastSlashfromUrl(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            string4 = "";
        }
        if (!bl) {
            throw new NoValidPathException(xMultiServiceFactory, "");
        }
        return string4;
    }

    public static ArrayList getOfficePaths(XMultiServiceFactory xMultiServiceFactory, String string, String string2, String string3) throws NoValidPathException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = "";
        try {
            int n;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            string4 = (String)xPropertySet.getPropertyValue(string + "_writable");
            String[] stringArray = (String[])xPropertySet.getPropertyValue(string + "_internal");
            String[] stringArray2 = (String[])xPropertySet.getPropertyValue(string + "_user");
            for (n = 0; n < stringArray.length; ++n) {
                String string5 = stringArray[n];
                if (string5.startsWith("vnd.")) {
                    String string6 = string5.substring("vnd.sun.star.Expand:".length());
                    XMacroExpander xMacroExpander = Helper.getMacroExpander(xMultiServiceFactory);
                    string5 = xMacroExpander.expandMacros(string6);
                }
                string5 = FileAccess.checkIfLanguagePathExists(xMultiServiceFactory, string5);
                arrayList.add(string5);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                arrayList.add(stringArray2[n]);
            }
            arrayList.add(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return arrayList;
    }

    private static String checkIfLanguagePathExists(XMultiServiceFactory xMultiServiceFactory, String string) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.text.Defaults");
            Locale locale = (Locale)Helper.getUnoStructValue(object, "CharLocale");
            if (locale == null) {
                java.util.Locale.getDefault();
                locale = new Locale();
                locale.Country = java.util.Locale.getDefault().getCountry();
                locale.Language = java.util.Locale.getDefault().getLanguage();
                locale.Variant = java.util.Locale.getDefault().getVariant();
            }
            String string2 = locale.Language;
            String string3 = locale.Country;
            String string4 = locale.Variant;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2).append('-').append(string3).append('-').append(string4);
            String string5 = string + "/" + stringBuffer.toString();
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string2).append('-').append(string3);
            string5 = string + "/" + stringBuffer2.toString();
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(string2);
            string5 = string + "/" + stringBuffer3.toString();
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            string5 = string + "/en-US";
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            string5 = string + "/en";
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void combinePaths(XMultiServiceFactory xMultiServiceFactory, ArrayList arrayList, String string) throws NoValidPathException {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (FileAccess.isPathValid(xMultiServiceFactory, string2 = FileAccess.addPath(string2, string))) {
                arrayList.add(i, string2);
                arrayList.remove(i + 1);
                continue;
            }
            arrayList.remove(i);
        }
    }

    public static boolean isPathValid(XMultiServiceFactory xMultiServiceFactory, String string) {
        boolean bl = false;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            bl = xSimpleFileAccess.exists(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return bl;
    }

    public static String combinePaths(XMultiServiceFactory xMultiServiceFactory, String string, String string2) throws NoValidPathException {
        boolean bl = false;
        String string3 = "";
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            string3 = string + string2;
            bl = xSimpleFileAccess.exists(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return "";
        }
        if (!bl) {
            throw new NoValidPathException(xMultiServiceFactory, "");
        }
        return string3;
    }

    public static boolean createSubDirectory(XMultiServiceFactory xMultiServiceFactory, XSimpleFileAccess xSimpleFileAccess, String string) {
        String string2 = "";
        try {
            Resource resource = new Resource(xMultiServiceFactory, "ImportWizard", "imp");
            if (resource != null) {
                string2 = resource.getResText(1050);
                String string3 = resource.getResText(1051);
                String string4 = resource.getResText(1052);
                String string5 = JavaTools.convertfromURLNotation(string);
                String string6 = JavaTools.replaceSubString(string3, string5, "%1");
                int n = SystemDialog.showMessageBox(xMultiServiceFactory, "QueryBox", 0x1000000, string6 = string6 + '\r' + string4);
                if (n == 2) {
                    xSimpleFileAccess.createFolder(string);
                    return true;
                }
            }
            return false;
        }
        catch (CommandAbortedException commandAbortedException) {
            String string7 = JavaTools.replaceSubString(string2, string, "%1");
            SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string7);
            return false;
        }
        catch (Exception exception) {
            String string8 = JavaTools.replaceSubString(string2, string, "%1");
            SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string8);
            return false;
        }
    }

    public static boolean PathisValid(XMultiServiceFactory xMultiServiceFactory, String string, String string2, boolean bl) {
        try {
            int n;
            int n2;
            Object object;
            String string3 = "";
            boolean bl2 = true;
            String string4 = string;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            if (bl && xSimpleFileAccess.exists(string)) {
                object = new Resource(xMultiServiceFactory, "ImportWizard", "imp");
                String string5 = ((Resource)object).getResText(1053);
                String string6 = JavaTools.convertfromURLNotation(string);
                string5 = JavaTools.replaceSubString(string5, string6, "<1>");
                n2 = SystemDialog.showMessageBox(xMultiServiceFactory, "QueryBox", 0x1000000, string5 = JavaTools.replaceSubString(string5, String.valueOf('\r'), "<CR>"));
                if (n2 == 3) {
                    return false;
                }
            }
            if ((n = ((String[])(object = JavaTools.ArrayoutofString(string, "/"))).length - 1) > 0) {
                for (int i = n; i >= 0; --i) {
                    boolean bl3;
                    Object object2 = object[i];
                    int n3 = ((String)object2).length();
                    int n4 = string4.length();
                    int n5 = n4 - n3;
                    if (n5 <= 0) continue;
                    string4 = string4.substring(0, n4 - n3 - 1);
                    if (i == n) {
                        string3 = string4;
                    }
                    if (bl3 = xSimpleFileAccess.exists(string4)) {
                        String string7 = string4.toLowerCase();
                        boolean bl4 = bl3 = !(string7.equals("file:///") || string7.equals("file://") || string7.equals("file:/") || string7.equals("file:"));
                    }
                    if (bl3) {
                        if (!bl2) {
                            n2 = FileAccess.createSubDirectory(xMultiServiceFactory, xSimpleFileAccess, string3) ? 1 : 0;
                            return n2 != 0;
                        }
                        return true;
                    }
                    bl2 = false;
                }
            }
            SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string2);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string2);
            return false;
        }
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        String[][] stringArray = new String[2][];
        try {
            Vector<String> vector = null;
            Vector<String> vector2 = null;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.document.StandaloneDocumentInfo");
            XStandaloneDocumentInfo xStandaloneDocumentInfo = (XStandaloneDocumentInfo)UnoRuntime.queryInterface(XStandaloneDocumentInfo.class, (Object)xInterface);
            XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface2);
            String[] stringArray2 = xSimpleFileAccess.getFolderContents(string2, false);
            vector = new Vector<String>(stringArray2.length);
            vector2 = new Vector<String>(stringArray2.length);
            string = string == null || string.equals("") ? null : string + "-";
            String string3 = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                string3 = FileAccess.getFilename(stringArray2[i]);
                if (string != null && !string3.startsWith(string)) continue;
                xStandaloneDocumentInfo.loadFromURL(stringArray2[i]);
                vector2.addElement(stringArray2[i]);
                vector.addElement(AnyConverter.toString((Object)Helper.getUnoPropertyValue(xInterface, "Title")));
            }
            Object[] objectArray = new String[vector2.size()];
            Object[] objectArray2 = new String[vector.size()];
            vector2.copyInto(objectArray);
            vector.copyInto(objectArray2);
            stringArray[1] = objectArray;
            stringArray[0] = objectArray2;
            JavaTools.bubblesortList(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return stringArray;
    }

    public static String addPath(String string, String string2) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        String string3 = string + string2;
        return string3;
    }

    public static String getPathFromList(XMultiServiceFactory xMultiServiceFactory, ArrayList arrayList, String string) {
        String string2 = "";
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (!xSimpleFileAccess.exists(string3 = FileAccess.addPath(string3, string))) continue;
                string2 = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMultiServiceFactory, String string, ArrayList arrayList) throws NoValidPathException {
        return FileAccess.getFolderTitles(xMultiServiceFactory, string, arrayList, "");
    }

    private static String getTitle(XMultiServiceFactory xMultiServiceFactory, String string) {
        String string2 = "";
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.document.StandaloneDocumentInfo");
            XStandaloneDocumentInfo xStandaloneDocumentInfo = (XStandaloneDocumentInfo)UnoRuntime.queryInterface(XStandaloneDocumentInfo.class, (Object)xInterface);
            xStandaloneDocumentInfo.loadFromURL(string);
            string2 = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xInterface, "Title"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMultiServiceFactory, String string, ArrayList arrayList, String string2) throws NoValidPathException {
        String[] stringArray;
        String[][] stringArray2 = new String[2][];
        if (arrayList.size() == 0) {
            throw new NoValidPathException(null, "Path not given.");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        XSimpleFileAccess xSimpleFileAccess = null;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NoValidPathException(null, "Internal error.");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = (String[])arrayList.get(i);
            try {
                String[] stringArray3 = xSimpleFileAccess.getFolderContents((String)stringArray, false);
                string = string == null || string.equals("") ? null : string + "-";
                String string3 = "";
                for (int j = 0; j < stringArray3.length; ++j) {
                    String string4;
                    string3 = FileAccess.getFilename(stringArray3[j]);
                    if (string != null && !string3.startsWith(string)) continue;
                    if (string2.equals("")) {
                        string4 = FileAccess.getTitle(xMultiServiceFactory, stringArray3[j]);
                    } else {
                        if (!string3.endsWith(string2)) continue;
                        string4 = string3 = string3.replaceAll(string2 + "$", "");
                    }
                    arrayList3.add(stringArray3[j]);
                    arrayList2.add(string4);
                }
                continue;
            }
            catch (CommandAbortedException commandAbortedException) {
                commandAbortedException.printStackTrace(System.out);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] stringArray4 = new String[arrayList3.size()];
        stringArray = new String[arrayList2.size()];
        arrayList3.toArray(stringArray4);
        arrayList2.toArray(stringArray);
        stringArray2[1] = stringArray4;
        stringArray2[0] = stringArray;
        JavaTools.bubblesortList(stringArray2);
        return stringArray2;
    }

    public FileAccess(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
        this.fileAccess = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)object);
        Object object2 = xMultiServiceFactory.createInstance("com.sun.star.ucb.FileContentProvider");
        this.filenameConverter = (XFileIdentifierConverter)UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)object2);
    }

    public String getURL(String string, String string2) {
        String string3 = this.filenameConverter.getSystemPathFromFileURL(string);
        File file = new File(string3, string2);
        String string4 = this.filenameConverter.getFileURLFromSystemPath(string, file.getAbsolutePath());
        return string4;
    }

    public String getURL(String string) {
        File file = new File(string);
        String string2 = this.filenameConverter.getFileURLFromSystemPath(string, file.getAbsolutePath());
        return string2;
    }

    public String getPath(String string, String string2) {
        return this.filenameConverter.getSystemPathFromFileURL(string + (string2 == null || string2.equals("") ? "" : "/" + string2));
    }

    public static String getExtension(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            return "";
        }
        while ((n = (string = string.substring(n + 1)).indexOf(".")) > -1) {
        }
        return string;
    }

    public boolean mkdir(String string) {
        try {
            this.fileAccess.createFolder(string);
            return true;
        }
        catch (CommandAbortedException commandAbortedException) {
            commandAbortedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean exists(String string, boolean bl) {
        try {
            return this.fileAccess.exists(string);
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isDirectory(String string) {
        try {
            return this.fileAccess.isFolder(string);
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String[] listFiles(String string, boolean bl) {
        try {
            return this.fileAccess.getFolderContents(string, bl);
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    public boolean delete(String string) {
        try {
            this.fileAccess.kill(string);
            return true;
        }
        catch (CommandAbortedException commandAbortedException) {
            commandAbortedException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public static String getFilename(String string) {
        return FileAccess.getFilename(string, "/");
    }

    public static String getPathFilename(String string) {
        return FileAccess.getFilename(string, File.separator);
    }

    public static String getFilename(String string, String string2) {
        String[] stringArray = JavaTools.ArrayoutofString(string, string2);
        return stringArray[stringArray.length - 1];
    }

    public static String getBasename(String string, String string2) {
        String string3 = FileAccess.getFilename(string, string2);
        String string4 = FileAccess.getExtension(string3);
        String string5 = string3.substring(0, string3.length() - (string4.length() + 1));
        return string5;
    }

    public boolean copy(String string, String string2) {
        try {
            this.fileAccess.copy(string, string2);
            return true;
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public DateTime getLastModified(String string) {
        try {
            return this.fileAccess.getDateTimeModified(string);
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getParentDir(String string) {
        if (string.endsWith("/")) {
            return FileAccess.getParentDir(string.substring(0, string.length() - 1));
        }
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf("/", n + 1)) > -1) {
            n2 = n;
        }
        return string.substring(0, n2);
    }

    public String createNewDir(String string, String string2) {
        String string3 = this.getNewFile(string, string2, "");
        if (this.mkdir(string3)) {
            return string3;
        }
        return null;
    }

    public String getNewFile(String string, String string2, String string3) {
        String string4;
        String string5;
        String string6;
        int n = 0;
        while (this.exists(string6 = (string5 = this.getURL(string, string4 = FileAccess.filename(string2, string3, n++))), true)) {
        }
        return string6;
    }

    private static String filename(String string, String string2, int n) {
        return string + (n == 0 ? "" : String.valueOf(n)) + (string2.equals("") ? "" : "." + string2);
    }

    public int getSize(String string) {
        try {
            return this.fileAccess.getSize(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String connectURLs(String string, String string2) {
        return string + (string.endsWith("/") ? "" : "/") + (string2.startsWith("/") ? string2.substring(1) : string2);
    }

    public static String[] getDataFromTextFile(XMultiServiceFactory xMultiServiceFactory, String string) {
        String[] stringArray = null;
        try {
            Vector<String> vector = new Vector<String>();
            Object object = xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)object);
            if (xSimpleFileAccess.exists(string)) {
                XInputStream xInputStream = xSimpleFileAccess.openFileRead(string);
                Object object2 = xMultiServiceFactory.createInstance("com.sun.star.io.TextInputStream");
                XTextInputStream xTextInputStream = (XTextInputStream)UnoRuntime.queryInterface(XTextInputStream.class, (Object)object2);
                XActiveDataSink xActiveDataSink = (XActiveDataSink)UnoRuntime.queryInterface(XActiveDataSink.class, (Object)object2);
                xActiveDataSink.setInputStream(xInputStream);
                while (!xTextInputStream.isEOF()) {
                    vector.addElement(xTextInputStream.readLine());
                }
                xTextInputStream.closeInput();
                stringArray = new String[vector.size()];
                vector.toArray(stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return stringArray;
    }

    public static String getShortFilename(String string, int n) {
        int n2 = 0;
        if (string.length() > n) {
            if (string.startsWith("/")) {
                int n3 = string.indexOf("/", 1) + 1;
                n2 = Math.min(n3, (n - 3) / 2);
            } else {
                n2 = Math.min(10, (n - 3) / 2);
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(string.length() - (n - (3 + n2)));
            return string2 + "..." + string3;
        }
        return string;
    }
}

