/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.servicetag;

import com.sun.star.servicetag.RegistrationData;
import com.sun.star.servicetag.Registry;
import com.sun.star.servicetag.ServiceTag;
import com.sun.star.servicetag.SolarisServiceTag;
import com.sun.star.servicetag.SunConnection;
import com.sun.star.servicetag.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    private static String SVCTAG_DIR_PATH = "servicetag.dir.path";
    private static String SVCTAG_ENABLE_REGISTRATION = "servicetag.registration.enabled";
    private static final String SUN_VENDOR = "Sun Microsystems";
    private static final String REGISTRATION_XML = "registration.xml";
    private static final String SERVICE_TAG_FILE = "servicetag";
    private static final String REGISTRATION_HTML_NAME = "register";
    private static final Locale[] knownSupportedLocales = new Locale[]{Locale.ENGLISH, Locale.JAPANESE, Locale.SIMPLIFIED_CHINESE};
    private static final String javaHome = System.getProperty("java.home");
    private static File svcTagDir;
    private static File serviceTagFile;
    private static File regXmlFile;
    private static RegistrationData registration;
    private static boolean supportRegistration;
    private static String registerHtmlParent;
    private static Set<Locale> supportedLocales;
    private static Properties swordfishProps;
    private static String[] jreArchs;
    private static final String JDK_HEADER_PNG_KEY = "@@JDK_HEADER_PNG@@";
    private static final String JDK_VERSION_KEY = "@@JDK_VERSION@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    private Installer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceTag getJavaServiceTag(String string) throws IOException {
        if (!System.getProperty("java.vendor").startsWith(SUN_VENDOR)) {
            return null;
        }
        boolean bl = false;
        try {
            if (Installer.loadSwordfishEntries() == null) {
                ServiceTag serviceTag = null;
                return serviceTag;
            }
            ServiceTag serviceTag = Installer.getJavaServiceTag();
            if (serviceTag != null && serviceTag.getSource().equals(string)) {
                if (Registry.isSupported()) {
                    Installer.installSystemServiceTag();
                }
                ServiceTag serviceTag2 = serviceTag;
                return serviceTag2;
            }
            bl = true;
            Installer.deleteRegistrationData();
            bl = false;
            ServiceTag serviceTag3 = Installer.createServiceTag(string);
            return serviceTag3;
        }
        finally {
            if (bl) {
                if (regXmlFile.exists()) {
                    regXmlFile.delete();
                }
                if (serviceTagFile.exists()) {
                    serviceTagFile.delete();
                }
            }
        }
    }

    private static synchronized RegistrationData getRegistrationData() throws IOException {
        if (registration != null) {
            return registration;
        }
        if (regXmlFile.exists()) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(regXmlFile));
                registration = RegistrationData.loadFromXML(bufferedInputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Error: Bad registration data \"" + regXmlFile + "\":" + illegalArgumentException.getMessage());
                throw illegalArgumentException;
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
        } else {
            registration = new RegistrationData();
        }
        return registration;
    }

    private static synchronized void writeRegistrationXml() throws IOException {
        if (!svcTagDir.exists() && !svcTagDir.mkdir()) {
            throw new IOException("Failed to create directory: " + svcTagDir);
        }
        Installer.deleteRegistrationHtmlPage();
        Installer.getRegistrationHtmlPage();
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(regXmlFile));
            Installer.getRegistrationData().storeToXML(filterOutputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: Bad registration data \"" + regXmlFile + "\":" + illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getInstalledURNs() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (serviceTagFile.exists()) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(serviceTagFile));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() <= 0) continue;
                    hashSet.add(string);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return hashSet;
    }

    private static ServiceTag[] getJavaServiceTagArray() throws IOException {
        RegistrationData registrationData = Installer.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        HashSet<ServiceTag> hashSet = new HashSet<ServiceTag>();
        Properties properties = Installer.loadSwordfishEntries();
        String string = properties.getProperty("servicetag.jdk.urn");
        String string2 = properties.getProperty("servicetag.jre.urn");
        for (ServiceTag serviceTag : set) {
            if (!serviceTag.getProductURN().equals(string) && !serviceTag.getProductURN().equals(string2)) continue;
            hashSet.add(serviceTag);
        }
        return hashSet.toArray(new ServiceTag[0]);
    }

    private static ServiceTag getJavaServiceTag() throws IOException {
        String string = Installer.getProductDefinedId();
        for (ServiceTag serviceTag : Installer.getJavaServiceTagArray()) {
            if (!serviceTag.getProductDefinedInstanceID().equals(string)) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag createServiceTag(String string) throws IOException {
        ServiceTag serviceTag = null;
        if (Installer.getJavaServiceTag() == null) {
            serviceTag = Installer.newServiceTag(string);
        }
        if (serviceTag != null) {
            RegistrationData registrationData = Installer.getRegistrationData();
            serviceTag = registrationData.addServiceTag(serviceTag);
            ServiceTag serviceTag2 = SolarisServiceTag.getServiceTag();
            if (serviceTag2 != null && registrationData.getServiceTag(serviceTag2.getInstanceURN()) == null) {
                registrationData.addServiceTag(serviceTag2);
            }
            Installer.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            Installer.installSystemServiceTag();
        }
        return serviceTag;
    }

    private static void installSystemServiceTag() throws IOException {
        if (!serviceTagFile.exists() && !svcTagDir.canWrite() || serviceTagFile.exists() && !serviceTagFile.canWrite()) {
            return;
        }
        Set<String> set = Installer.getInstalledURNs();
        ServiceTag[] serviceTagArray = Installer.getJavaServiceTagArray();
        if (set.size() < serviceTagArray.length) {
            for (ServiceTag serviceTag : serviceTagArray) {
                String string = serviceTag.getInstanceURN();
                if (set.contains(string)) continue;
                Registry.getSystemRegistry().addServiceTag(serviceTag);
            }
        }
        Installer.writeInstalledUrns();
    }

    private static ServiceTag newServiceTag(String string) throws IOException {
        String string2;
        String string3;
        Properties properties = Installer.loadSwordfishEntries();
        if (Util.isJdk()) {
            string3 = properties.getProperty("servicetag.jdk.urn");
            string2 = properties.getProperty("servicetag.jdk.name");
        } else {
            string3 = properties.getProperty("servicetag.jre.urn");
            string2 = properties.getProperty("servicetag.jre.name");
        }
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string2, System.getProperty("java.version"), string3, properties.getProperty("servicetag.parent.name"), properties.getProperty("servicetag.parent.urn"), Installer.getProductDefinedId(), SUN_VENDOR, System.getProperty("os.arch"), Installer.getZoneName(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteRegistrationData() throws IOException {
        try {
            Installer.deleteRegistrationHtmlPage();
            Set<String> set = Installer.getInstalledURNs();
            if (set.size() > 0 && Registry.isSupported()) {
                for (String string : set) {
                    Registry.getSystemRegistry().removeServiceTag(string);
                }
            }
            registration = null;
        }
        finally {
            if (regXmlFile.exists() && !regXmlFile.delete()) {
                throw new IOException("Failed to delete " + regXmlFile);
            }
            if (serviceTagFile.exists() && !serviceTagFile.delete()) {
                throw new IOException("Failed to delete " + serviceTagFile);
            }
        }
    }

    private static synchronized void updateRegistrationData(String string) throws IOException {
        RegistrationData registrationData = Installer.getRegistrationData();
        ServiceTag serviceTag = Installer.newServiceTag(string);
        ServiceTag[] serviceTagArray = Installer.getJavaServiceTagArray();
        Set<String> set = Installer.getInstalledURNs();
        for (ServiceTag serviceTag2 : serviceTagArray) {
            if (serviceTag2.getProductDefinedInstanceID().equals(serviceTag.getProductDefinedInstanceID())) continue;
            String string2 = serviceTag2.getInstanceURN();
            registrationData.removeServiceTag(string2);
            if (!set.contains(string2) || !Registry.isSupported()) continue;
            Registry.getSystemRegistry().removeServiceTag(string2);
        }
        Installer.writeRegistrationXml();
        Installer.writeInstalledUrns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInstalledUrns() throws IOException {
        if (!Registry.isSupported() && serviceTagFile.exists()) {
            serviceTagFile.delete();
            return;
        }
        PrintWriter printWriter = null;
        try {
            ServiceTag[] serviceTagArray;
            printWriter = new PrintWriter(serviceTagFile);
            for (ServiceTag serviceTag : serviceTagArray = Installer.getJavaServiceTagArray()) {
                String string = serviceTag.getInstanceURN();
                printWriter.println(string);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Properties loadSwordfishEntries() throws IOException {
        if (swordfishProps != null) {
            return swordfishProps;
        }
        int n = Util.getJdkVersion();
        String string = "/com/sun/servicetag/resources/javase_" + n + "_swordfish.properties";
        InputStream inputStream = Installer.class.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        swordfishProps = new Properties();
        try {
            swordfishProps.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return swordfishProps;
    }

    private static String getProductDefinedId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(System.getProperty("java.runtime.version"));
        String[] stringArray = Installer.getJreArchs();
        for (String string : stringArray) {
            stringBuilder.append(" " + string);
        }
        String string = ",dir=" + javaHome;
        if (stringBuilder.length() + string.length() < 256) {
            stringBuilder.append(",dir=");
            stringBuilder.append(javaHome);
        } else if (Util.isVerbose()) {
            System.err.println("Warning: Product defined instance ID exceeds the field limit:");
        }
        return stringBuilder.toString();
    }

    private static synchronized String[] getJreArchs() {
        if (jreArchs != null) {
            return jreArchs;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = System.getProperty("os.name");
        if (string.equals("SunOS") || string.equals("Linux")) {
            File file = new File(Util.getJrePath() + File.separator + "lib");
            if (file.isDirectory()) {
                String[] stringArray;
                for (String string2 : stringArray = file.list()) {
                    File file2 = new File(file, string2 + File.separator + "libjava.so");
                    if (!file2.exists()) continue;
                    hashSet.add(string2);
                }
            }
        } else {
            hashSet.add(System.getProperty("os.arch"));
        }
        jreArchs = hashSet.toArray(new String[0]);
        return jreArchs;
    }

    public static String getZoneName() throws IOException {
        String string = "global";
        String string2 = "/usr/bin/zonename";
        File file = new File(string2);
        if (file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string2);
            Process process = processBuilder.start();
            String string3 = Util.commandOutput(process);
            if (process.exitValue() == 0) {
                string = string3.trim();
            }
        }
        return string;
    }

    private static synchronized String getRegisterHtmlParent() throws IOException {
        if (registerHtmlParent == null) {
            File file = Util.getJrePath().endsWith(File.separator + "jre") ? new File(Util.getJrePath(), "..") : new File(Util.getJrePath());
            Installer.initSupportedLocales(file);
            String string = System.getProperty(SVCTAG_DIR_PATH);
            if (string == null) {
                registerHtmlParent = file.getCanonicalPath();
            } else {
                File file2 = new File(string);
                registerHtmlParent = file2.getCanonicalPath();
                if (!file2.isDirectory()) {
                    throw new InternalError("Path " + string + " set in \"" + SVCTAG_DIR_PATH + "\" property is not a directory");
                }
            }
        }
        return registerHtmlParent;
    }

    static synchronized File getRegistrationHtmlPage() throws IOException {
        if (!supportRegistration) {
            return null;
        }
        String string = Installer.getRegisterHtmlParent();
        File file = new File(string, "register.html");
        if (!file.exists()) {
            Installer.generateRegisterHtml(string);
        }
        String string2 = REGISTRATION_HTML_NAME;
        List<Locale> list = Installer.getCandidateLocales(Locale.getDefault());
        for (Locale locale : list) {
            if (!supportedLocales.contains(locale)) continue;
            string2 = "register_" + locale.toString();
            break;
        }
        File file2 = new File(string, string2 + ".html");
        if (Util.isVerbose()) {
            System.out.print("Offline registration page: " + file2);
            System.out.println(file2.exists() ? "" : " not exist. Use register.html");
        }
        if (file2.exists()) {
            return file2;
        }
        return new File(string, "register.html");
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        ArrayList<Locale> arrayList = new ArrayList<Locale>(3);
        if (string3.length() > 0) {
            arrayList.add(locale);
        }
        if (string2.length() > 0) {
            arrayList.add(arrayList.size() == 0 ? locale : new Locale(string, string2, ""));
        }
        if (string.length() > 0) {
            arrayList.add(arrayList.size() == 0 ? locale : new Locale(string, "", ""));
        }
        return arrayList;
    }

    private static void deleteRegistrationHtmlPage() throws IOException {
        String string = Installer.getRegisterHtmlParent();
        if (string == null) {
            return;
        }
        for (Locale locale : supportedLocales) {
            File file;
            String string2 = REGISTRATION_HTML_NAME;
            if (!locale.equals(Locale.ENGLISH)) {
                string2 = string2 + "_" + locale.toString();
            }
            if (!(file = new File(string, string2 + ".html")).exists() || file.delete()) continue;
            throw new IOException("Failed to delete " + file);
        }
    }

    private static void initSupportedLocales(File file) {
        if (supportedLocales.isEmpty()) {
            for (Locale locale : knownSupportedLocales) {
                supportedLocales.add(locale);
            }
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.startsWith("readme") && string2.endsWith(".html");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        block6: for (String string : stringArray) {
            String string2 = string.substring(0, string.length() - ".html".length());
            String[] stringArray2 = string2.split("_");
            switch (stringArray2.length) {
                case 1: {
                    continue block6;
                }
                case 2: {
                    supportedLocales.add(new Locale(stringArray2[1]));
                    continue block6;
                }
                case 3: {
                    supportedLocales.add(new Locale(stringArray2[1], stringArray2[2]));
                    continue block6;
                }
            }
        }
        if (Util.isVerbose()) {
            System.out.println("Supported locales: ");
            for (Locale locale : supportedLocales) {
                System.out.println(locale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateRegisterHtml(String string) throws IOException {
        String string2;
        int n = Util.getJdkVersion();
        int n2 = Util.getUpdateVersion();
        String string3 = "Version " + n;
        if (n2 > 0) {
            string3 = string3 + " Update " + n2;
        }
        RegistrationData registrationData = Installer.getRegistrationData();
        String string4 = SunConnection.getRegistrationURL(registrationData.getRegistrationURN()).toString();
        File file = new File(svcTagDir.getCanonicalPath(), "jdk_header.png");
        String string5 = file.toURI().toString();
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = registrationData.toString().replaceAll("\"", "%22");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string6));
        try {
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2.trim());
            }
        }
        finally {
            bufferedReader.close();
        }
        string2 = "/com/sun/star/servicetag/resources/register";
        for (Locale locale : supportedLocales) {
            String string7 = REGISTRATION_HTML_NAME;
            String string8 = string2;
            if (!locale.equals(Locale.ENGLISH)) {
                string7 = string7 + "_" + locale.toString();
                string8 = string8 + "_" + locale.toString();
            }
            File file2 = new File(string, string7 + ".html");
            InputStream inputStream = null;
            BufferedReader bufferedReader2 = null;
            PrintWriter printWriter = null;
            try {
                inputStream = Installer.class.getClass().getResourceAsStream(string8 + ".html");
                if (inputStream == null) {
                    if (!Util.isVerbose()) continue;
                    System.out.println("Missing resouce file: " + string8 + ".html");
                    continue;
                }
                if (Util.isVerbose()) {
                    System.out.println("Generating " + file2 + " from " + string8 + ".html");
                }
                bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                printWriter = new PrintWriter(file2, "UTF-8");
                String string9 = null;
                while ((string9 = bufferedReader2.readLine()) != null) {
                    String string10 = string9;
                    if (string9.contains(JDK_VERSION_KEY)) {
                        string10 = string9.replace(JDK_VERSION_KEY, string3);
                    } else if (string9.contains(JDK_HEADER_PNG_KEY)) {
                        string10 = string9.replace(JDK_HEADER_PNG_KEY, string5);
                    } else if (string9.contains(REGISTRATION_URL_KEY)) {
                        string10 = string9.replace(REGISTRATION_URL_KEY, string4);
                    } else if (string9.contains(REGISTRATION_PAYLOAD_KEY)) {
                        string10 = string9.replace(REGISTRATION_PAYLOAD_KEY, stringBuilder.toString());
                    }
                    printWriter.println(string10);
                }
                file2.setReadOnly();
                printWriter.flush();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader2 == null) continue;
                bufferedReader2.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        block20: {
            Object object;
            String string = "Manual";
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                if (((String)object).trim().length() == 0) {
                    ++n;
                    continue;
                }
                if (((String)object).equals("-source")) {
                    string = stringArray[++n];
                } else if (((String)object).equals("-delete")) {
                    bl = true;
                } else if (((String)object).equals("-register")) {
                    bl3 = true;
                } else {
                    Installer.usage();
                    return;
                }
                ++n;
            }
            try {
                if (bl) {
                    Installer.deleteRegistrationData();
                } else {
                    String[] stringArray2;
                    object = Installer.getJavaServiceTagArray();
                    if (((ServiceTag[])object).length > (stringArray2 = Installer.getJreArchs()).length) {
                        Installer.updateRegistrationData(string);
                    } else {
                        Installer.createServiceTag(string);
                    }
                }
                if (bl3) {
                    object = Installer.getRegistrationData();
                    if (supportRegistration && !((RegistrationData)object).getServiceTags().isEmpty()) {
                        SunConnection.register((RegistrationData)object);
                    }
                }
                System.exit(0);
            }
            catch (IOException iOException) {
                System.err.println("I/O Error: " + iOException.getMessage());
                if (Util.isVerbose()) {
                    iOException.printStackTrace();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Util.isVerbose()) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
                if (!Util.isVerbose()) break block20;
                exception.printStackTrace();
            }
        }
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.print("    " + Installer.class.getName());
        System.out.println(" [-delete|-source <source>|-register]");
        System.out.println("       to create a service tag for the Java platform");
        System.out.println("");
        System.out.println("Internal Options:");
        System.out.println("    -source: to specify the source of the service tag to be created");
        System.out.println("    -delete: to delete the service tag ");
        System.out.println("    -register: to register the JDK");
        System.out.println("    -help:   to print this help message");
    }

    static {
        supportedLocales = new HashSet<Locale>();
        swordfishProps = null;
        jreArchs = null;
        String string = System.getProperty(SVCTAG_DIR_PATH);
        svcTagDir = string == null ? new File(Util.getJrePath(), "lib" + File.separator + SERVICE_TAG_FILE) : new File(string);
        serviceTagFile = new File(svcTagDir, SERVICE_TAG_FILE);
        regXmlFile = new File(svcTagDir, REGISTRATION_XML);
        supportRegistration = System.getProperty(SVCTAG_ENABLE_REGISTRATION) == null ? Util.isJdk() : true;
    }
}

