/*
 * VFcap.h 
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  h.kakugawa@computer.org
 *
 *  Edition History
 *  29 Oct 1993
 *  22 Jan 1994 
 *  22 Dec 1995
 *  19 Feb 1996  "en" and "cs" entries added. (WL)
 *
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1993-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VFLIB_VFCAP_H__

#define __VFLIB_VFCAP_H__

int    VFC_Init();
int    VFC_Deinit();
int    VFC_GetEntry();
char*  VFC_GetString();
int    VFC_GetNumber();
int    VFC_IsDefined();

#define VFCE_FONT_TYPE   "ft"
#define VFCE_PRIM_FONT   "tp"
#define VFCE_FONT_FILE   "ff"
#define VFCE_ENCODING    "en"
#define VFCE_CHARSET     "cs"

#define VFCE_KANA        "kn"
#define VFCE_KANJI       "kj"
#define VFCE_SYMBOL      "sy"

#define VFCE_FRAME       "fr"
#define VFCE_THICKEN     "th"
#define VFCE_SLANT       "sl"
#define VFCE_SHADOW      "sh"
#define VFCE_ROTATE      "ro"
#define VFCE_REF_X       "rx"
#define VFCE_REF_Y       "ry"

#define VFCE_XOFFSET     "ox"
#define VFCE_YOFFSET     "oy"
#define VFCE_XFACTOR     "fx"
#define VFCE_YFACTOR     "fy"

#define VFCE_REVERSE     "rv"
#define VFCE_OPERATIONS  "op"
#define VFCE_FONTENTRY   "fo"
#define VFCE_SUBFONTENTRY "sf"
#define VFCE_DOTSIZEFACT "dz"
#define VFCE_DOTSHAPE    "ds"


#define VFCE_C2_FONT_1   "fA"
#define VFCE_C2_FONT_16  "fP"
#define VFCE_C2_RANGE_1  "rA"
#define VFCE_C2_RANGE_16 "rP"


#endif  /*__VFLIB_VFCAP_H__*/

