# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.08.10
#
# Package: 
#   VFlib2-2.25.6.tgz
#
# Files:
#   ftp://typehack.aial.hiroshima-u.ac.jp/pub/TypeHack/VFlib2-2.25.6.tar.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
#!/bin/sh
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=VFlib2
VERSION=2.25.6
PREFIX=/usr/local
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}

#make
./configure --with-freetype --with-freetype-includedir=/usr/include/freetype1/freetype --with-freetype-libdir=/usr/X11R6/lib
make
make install -e prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}

#makepkg
echo 'Creating package now ...'
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cp ${PKGROOT}/${PACKAGE}-${VERSION}/CHANGES ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/COPYING ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/COPYING.LIB ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/DISTRIB.txt ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/INSTALL ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/README.txt ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/README.txt.JP_EUC ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vfontcap ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/share/VFlib/2.25.2
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install

cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

