#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.07
#
# Package: 
#   ghostscript-cjk-7.05-i386-1.tgz
#
# Files:
#   ftp://ftp.gnu.org/pub/gnu/ghostscript/ghostscript-7.05.tar.gz
#   ftp://ftp.gyve.org/pub/gs-cjk/adobe-cmaps-200202.tar.gz
#   ftp://ftp.gyve.org/pub/gs-cjk/acro5-cmaps-2001.tar.gz
#   ftp://ftp.gyve.org/pub/gs-cjk/snapshot/gs6.51-cjk-20011102.tar.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=ghostscript
VERSION=7.05
PKGROOT=`pwd`
# If you change PREFIX, change line 41, too.
PREFIX=/usr/local
TTF_MIN=Kochi-Mincho
TTF_GOTH=Kochi-Gothic

tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
tar -zxvf gs6.51-cjk-20011102.tar.gz -C${PACKAGE}-${VERSION}

#make
cd ${PACKAGE}-${VERSION}
cat src/Makefile.in | sed 's/DEVICE_DEVS6=$(DD)bj10e.dev $(DD)bj200.dev $(DD)bjc600.dev $(DD)bjc800.dev/DEVICE_DEVS6=$(DD)bj10e.dev $(DD)bj200.dev $(DD)bjc600.dev $(DD)bjc800.dev $(DD)stcolor.dev/g' > src/Makefile.in.tmp
mv src/Makefile.in.tmp src/Makefile.in

./configure --prefix=${PREFIX} --with-gimp-print --with-x
make
make install

#
cd ${PREFIX}/share/ghostscript
tar -zxvf ${PKGROOT}/gnu-gs-fonts-std-6.0.tar.gz 
tar -zxvf ${PKGROOT}/gnu-gs-fonts-other-6.0.tar.gz 
cat ${VERSION}/lib/gs_res.ps | sed 's/\/Resource\/Font/\/Resource\/CIDFont/g' >  ${VERSION}/lib/gs_res.ps.tmp
mv ${VERSION}/lib/gs_res.ps.tmp ${VERSION}/lib/gs_res.ps
cat ${VERSION}/lib/gs_res.ps | sed 's/\/Resource\//\/usr\/local\/share\/ghostscript\/Resource\//g' >  ${VERSION}/lib/gs_res.ps.tmp
mv ${VERSION}/lib/gs_res.ps.tmp ${VERSION}/lib/gs_res.ps
mkdir -p Resource/{Font,CIDFont}
cd Resource
tar -zxvf ${PKGROOT}/adobe-cmaps-200202.tar.gz
tar -zxvf ${PKGROOT}/acro5-cmaps-2001.tar.gz
tar -zxvf ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/install-cid.tar.gz
cd CIDFont
cp ${PKGROOT}/Kochi-Mincho.bz2 .
bunzip2 Kochi-Mincho.bz2
cp ${PKGROOT}/Kochi-Gothic.bz2 .
bunzip2 Kochi-Gothic.bz2

#create postinst.sh
echo 'pushd .' > ${PKGROOT}/postinst.sh
echo -n 'cd ' >> ${PKGROOT}/postinst.sh
echo ${PREFIX}/share/ghostscript/Resource >> ${PKGROOT}/postinst.sh
echo './aj1.sh install Kochi-Mincho' >> ${PKGROOT}/postinst.sh 
echo './aj2.sh install Kochi-Mincho' >> ${PKGROOT}/postinst.sh
echo -n './alias-aj1.sh install Ryumin-Light=' >> ${PKGROOT}/postinst.sh
echo ${TTF_MIN} >> ${PKGROOT}/postinst.sh
echo -n './alias-aj2.sh install Ryumin-Light=' >> ${PKGROOT}/postinst.sh
echo ${TTF_MIN} >> ${PKGROOT}/postinst.sh
echo './aj1.sh install Kochi-Gothic' >> ${PKGROOT}/postinst.sh
echo './aj2.sh install Kochi-Gothic' >> ${PKGROOT}/postinst.sh
echo -n './alias-aj1.sh install GothicBBB-Medium=' >> ${PKGROOT}/postinst.sh
echo ${TTF_GOTH} >> ${PKGROOT}/postinst.sh
echo -n './alias-aj2.sh install GothicBBB-Medium=' >> ${PKGROOT}/postinst.sh
echo ${TTF_GOTH} >> ${PKGROOT}/postinst.sh
echo './aj1.sh install Ryumin-Light' >> ${PKGROOT}/postinst.sh
echo './aj1.sh install GothicBBB-Medium' >> ${PKGROOT}/postinst.sh
echo 'popd' >> ${PKGROOT}/postinst.sh
chmod u+x ${PKGROOT}/postinst.sh

#makepkg
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/share
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv ${PREFIX}/bin/bdftops ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/dvipdf ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/eps2eps ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/fixmswrd.pl ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/font2c ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gs ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gsbj ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gsdj ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gsdj500 ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gslj ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gslp ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/gsnd ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/lprsetup.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pdf2dsc ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pdf2ps ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pdfopt ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pf2afm ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pfbtopfa ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pj-gs.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/printafm ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2ascii ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2epsi ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2pdf ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2pdf12 ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2pdf13 ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2pdf14 ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2pdfwr ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/ps2ps ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/pv.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/sysvlp.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/unix-lpr.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/bin/wftopfa ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
mv ${PREFIX}/share/ghostscript ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/share
mv ${PREFIX}/man/de/man1/ansi2knr.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/dvipdf.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/font2c.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/gsnd.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/pdf2dsc.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/pdf2ps.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/pdfopt.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/printafm.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/ps2ascii.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/ps2pdf.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/ps2ps.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
mv ${PREFIX}/man/de/man1/wftopfa.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/de/man1
ln -s ps2ps.1 eps2eps.1
ln -s ps2pdf.1 ps2pdf12.1
ln -s ps2pdf.1 ps2pdf13.1
mv ${PREFIX}/man/man1/ansi2knr.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/dvipdf.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/font2c.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/gs.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/gslp.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/gsnd.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/pdf2dsc.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/pdf2ps.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/pdfopt.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/pfbtopfa.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/printafm.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/ps2ascii.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/ps2epsi.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/ps2pdf.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/ps2ps.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv ${PREFIX}/man/man1/wftopfa.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
ln -s ps2ps.1 eps2eps.1
ln -s gslp.1  gsbj.1
ln -s gslp.1  gsdj.1
ln -s gslp.1  gsdj500.1
ln -s gslp.1  gslj.1
ln -s ps2pdf.1 ps2pdf12.1
ln -s ps2pdf.1 ps2pdf13.1
cp ${PKGROOT}/${PACKAGE}-${VERSION}/LICENSE  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/ANNOUNCE  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/CJKTTCID.INF  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/COPYING  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/ChangeLog  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/FILES  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/HACKING ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/NEWS  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/${PACKAGE}-${VERSION}/gs6.51-cjk-20011102/README*  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/gs6.51-cjk
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-cjk-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-cjk-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

