# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.20
#
# Package: 
#   grip-3.0.1-i386-1.tgz
#
# Files:
#   http://sourceforge.net/projects/grip
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
#!/bin/sh
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=grip
VERSION=3.0.1
PREFIX=/usr/local
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}

#make
./configure
make
make install -e prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}

#makepkg
echo 'Creating package now ...'
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cp ./ABOUT-NLS  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./AUTHORS    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./COPYING    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./CREDITS    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./ChangeLog  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./INSTALL    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./NEWS       ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./README     ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./TODO       ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

