#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.07
#
# Package: 
#   rxvt-2.7.8-i386-1.tgz
#
# Files:
#   ftp://ftp.rxvt.org/pub/rxvt/rxvt-2.7.8.tar.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=rxvt
VERSION=2.7.8
PREFIX=/usr/local
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}

#make
./configure --prefix=${PREFIX} --enable-languages --with-encoding=eucj --enable-utmp --enable-wtmp --enable-xpm-background --enable-transparency --enable-menubar --enable-graphics --enable-rxvt-scroll --enable-next-scroll --enable-half-shadow --enable-xim --enable-ttygid --disable-backspace-key --disable-delete-key --enable-linespace --enable-keepscrolling --enable-mousewheel --with-x 
make
make install prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}

#makepkg
echo 'Creating package now ...'
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install

mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/man ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share
cp ./ChangeLog           ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./INSTALL             ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./README.configure    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp -R ./doc              ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install

cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

